/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.std.join;

import edu.uci.ics.hyracks.api.comm.IFrameTupleAccessor;
import edu.uci.ics.hyracks.api.comm.IFrameWriter;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.value.INullWriter;
import edu.uci.ics.hyracks.api.dataflow.value.IPredicateEvaluator;
import edu.uci.ics.hyracks.api.dataflow.value.ITuplePairComparator;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.api.io.FileReference;
import edu.uci.ics.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import edu.uci.ics.hyracks.dataflow.common.comm.util.FrameUtils;
import edu.uci.ics.hyracks.dataflow.common.io.RunFileReader;
import edu.uci.ics.hyracks.dataflow.common.io.RunFileWriter;
import java.io.DataOutput;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class NestedLoopJoin {
    private final FrameTupleAccessor accessorInner;
    private final FrameTupleAccessor accessorOuter;
    private final FrameTupleAppender appender;
    private final ITuplePairComparator tpComparator;
    private final ByteBuffer outBuffer;
    private final ByteBuffer innerBuffer;
    private final List<ByteBuffer> outBuffers;
    private final int memSize;
    private final IHyracksTaskContext ctx;
    private RunFileReader runFileReader;
    private int currentMemSize = 0;
    private final RunFileWriter runFileWriter;
    private final boolean isLeftOuter;
    private final ArrayTupleBuilder nullTupleBuilder;
    private final IPredicateEvaluator predEvaluator;
    private boolean isReversed;

    public NestedLoopJoin(IHyracksTaskContext ctx, FrameTupleAccessor accessor0, FrameTupleAccessor accessor1, ITuplePairComparator comparators, int memSize, IPredicateEvaluator predEval, boolean isLeftOuter, INullWriter[] nullWriters1) throws HyracksDataException {
        this.accessorInner = accessor1;
        this.accessorOuter = accessor0;
        this.appender = new FrameTupleAppender(ctx.getFrameSize());
        this.tpComparator = comparators;
        this.outBuffer = ctx.allocateFrame();
        this.innerBuffer = ctx.allocateFrame();
        this.appender.reset(this.outBuffer, true);
        this.outBuffers = new ArrayList<ByteBuffer>();
        this.memSize = memSize;
        this.predEvaluator = predEval;
        this.isReversed = false;
        this.ctx = ctx;
        this.isLeftOuter = isLeftOuter;
        if (isLeftOuter) {
            int innerFieldCount = this.accessorInner.getFieldCount();
            this.nullTupleBuilder = new ArrayTupleBuilder(innerFieldCount);
            DataOutput out = this.nullTupleBuilder.getDataOutput();
            for (int i = 0; i < innerFieldCount; ++i) {
                nullWriters1[i].writeNull(out);
                this.nullTupleBuilder.addFieldEndOffset();
            }
        } else {
            this.nullTupleBuilder = null;
        }
        FileReference file = ctx.getJobletContext().createManagedWorkspaceFile(this.getClass().getSimpleName() + this.toString());
        this.runFileWriter = new RunFileWriter(file, ctx.getIOManager());
        this.runFileWriter.open();
    }

    public void cache(ByteBuffer buffer) throws HyracksDataException {
        this.runFileWriter.nextFrame(buffer);
    }

    public void join(ByteBuffer outerBuffer, IFrameWriter writer) throws HyracksDataException {
        if (this.outBuffers.size() < this.memSize - 3) {
            this.createAndCopyFrame(outerBuffer);
            return;
        }
        if (this.currentMemSize < this.memSize - 3) {
            this.reloadFrame(outerBuffer);
            return;
        }
        this.runFileReader = this.runFileWriter.createReader();
        this.runFileReader.open();
        while (this.runFileReader.nextFrame(this.innerBuffer)) {
            for (ByteBuffer outBuffer : this.outBuffers) {
                this.blockJoin(outBuffer, this.innerBuffer, writer);
            }
        }
        this.runFileReader.close();
        this.currentMemSize = 0;
        this.reloadFrame(outerBuffer);
    }

    private void createAndCopyFrame(ByteBuffer outerBuffer) throws HyracksDataException {
        ByteBuffer outerBufferCopy = this.ctx.allocateFrame();
        FrameUtils.copy((ByteBuffer)outerBuffer, (ByteBuffer)outerBufferCopy);
        this.outBuffers.add(outerBufferCopy);
        ++this.currentMemSize;
    }

    private void reloadFrame(ByteBuffer outerBuffer) {
        this.outBuffers.get(this.currentMemSize).clear();
        FrameUtils.copy((ByteBuffer)outerBuffer, (ByteBuffer)this.outBuffers.get(this.currentMemSize));
        ++this.currentMemSize;
    }

    private void blockJoin(ByteBuffer outerBuffer, ByteBuffer innerBuffer, IFrameWriter writer) throws HyracksDataException {
        this.accessorOuter.reset(outerBuffer);
        this.accessorInner.reset(innerBuffer);
        int tupleCount0 = this.accessorOuter.getTupleCount();
        int tupleCount1 = this.accessorInner.getTupleCount();
        for (int i = 0; i < tupleCount0; ++i) {
            int ntSize;
            byte[] ntByteArray;
            int[] ntFieldEndOffsets;
            boolean matchFound = false;
            for (int j = 0; j < tupleCount1; ++j) {
                int c = this.compare(this.accessorOuter, i, this.accessorInner, j);
                boolean prdEval = this.evaluatePredicate(i, j);
                if (c != 0 || !prdEval) continue;
                matchFound = true;
                this.appendToResults(i, j, writer);
            }
            if (matchFound || !this.isLeftOuter || this.appender.appendConcat((IFrameTupleAccessor)this.accessorOuter, i, ntFieldEndOffsets = this.nullTupleBuilder.getFieldEndOffsets(), ntByteArray = this.nullTupleBuilder.getByteArray(), 0, ntSize = this.nullTupleBuilder.getSize())) continue;
            this.flushFrame(this.outBuffer, writer);
            this.appender.reset(this.outBuffer, true);
            if (this.appender.appendConcat((IFrameTupleAccessor)this.accessorOuter, i, ntFieldEndOffsets, ntByteArray, 0, ntSize)) continue;
            int tSize = this.accessorOuter.getTupleEndOffset(i) - this.accessorOuter.getTupleStartOffset(i) + ntSize;
            throw new HyracksDataException("Record size (" + tSize + ") larger than frame size (" + this.appender.getBuffer().capacity() + ")");
        }
    }

    private boolean evaluatePredicate(int tIx1, int tIx2) {
        if (this.isReversed) {
            return this.predEvaluator == null || this.predEvaluator.evaluate((IFrameTupleAccessor)this.accessorInner, tIx2, (IFrameTupleAccessor)this.accessorOuter, tIx1);
        }
        return this.predEvaluator == null || this.predEvaluator.evaluate((IFrameTupleAccessor)this.accessorOuter, tIx1, (IFrameTupleAccessor)this.accessorInner, tIx2);
    }

    private void appendToResults(int outerTupleId, int innerTupleId, IFrameWriter writer) throws HyracksDataException {
        if (!this.isReversed) {
            this.appendResultToFrame(this.accessorOuter, outerTupleId, this.accessorInner, innerTupleId, writer);
        } else {
            this.appendResultToFrame(this.accessorInner, innerTupleId, this.accessorOuter, outerTupleId, writer);
        }
    }

    private void appendResultToFrame(FrameTupleAccessor accessor1, int tupleId1, FrameTupleAccessor accessor2, int tupleId2, IFrameWriter writer) throws HyracksDataException {
        if (!this.appender.appendConcat((IFrameTupleAccessor)accessor1, tupleId1, (IFrameTupleAccessor)accessor2, tupleId2)) {
            this.flushFrame(this.outBuffer, writer);
            this.appender.reset(this.outBuffer, true);
            if (!this.appender.appendConcat((IFrameTupleAccessor)accessor1, tupleId1, (IFrameTupleAccessor)accessor2, tupleId2)) {
                int tSize = accessor1.getTupleEndOffset(tupleId1) - accessor1.getTupleStartOffset(tupleId1) + accessor2.getTupleEndOffset(tupleId2) - accessor2.getTupleStartOffset(tupleId2);
                throw new HyracksDataException("Record size (" + tSize + ") larger than frame size (" + this.appender.getBuffer().capacity() + ")");
            }
        }
    }

    public void closeCache() throws HyracksDataException {
        if (this.runFileWriter != null) {
            this.runFileWriter.close();
        }
    }

    public void closeJoin(IFrameWriter writer) throws HyracksDataException {
        this.runFileReader = this.runFileWriter.createReader();
        this.runFileReader.open();
        while (this.runFileReader.nextFrame(this.innerBuffer)) {
            for (int i = 0; i < this.currentMemSize; ++i) {
                this.blockJoin(this.outBuffers.get(i), this.innerBuffer, writer);
            }
        }
        this.runFileReader.close();
        this.outBuffers.clear();
        this.currentMemSize = 0;
        if (this.appender.getTupleCount() > 0) {
            this.flushFrame(this.outBuffer, writer);
        }
    }

    private void flushFrame(ByteBuffer buffer, IFrameWriter writer) throws HyracksDataException {
        buffer.position(0);
        buffer.limit(buffer.capacity());
        writer.nextFrame(buffer);
        buffer.position(0);
        buffer.limit(buffer.capacity());
    }

    private int compare(FrameTupleAccessor accessor0, int tIndex0, FrameTupleAccessor accessor1, int tIndex1) throws HyracksDataException {
        int c = this.tpComparator.compare((IFrameTupleAccessor)accessor0, tIndex0, (IFrameTupleAccessor)accessor1, tIndex1);
        if (c != 0) {
            return c;
        }
        return 0;
    }

    public void setIsReversed(boolean b) {
        this.isReversed = b;
    }
}

