/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.std.join;

import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.ActivityId;
import edu.uci.ics.hyracks.api.dataflow.IActivity;
import edu.uci.ics.hyracks.api.dataflow.IActivityGraphBuilder;
import edu.uci.ics.hyracks.api.dataflow.IOperatorDescriptor;
import edu.uci.ics.hyracks.api.dataflow.IOperatorNodePushable;
import edu.uci.ics.hyracks.api.dataflow.TaskId;
import edu.uci.ics.hyracks.api.dataflow.state.IStateObject;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryComparator;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryHashFunctionFactory;
import edu.uci.ics.hyracks.api.dataflow.value.INullWriter;
import edu.uci.ics.hyracks.api.dataflow.value.INullWriterFactory;
import edu.uci.ics.hyracks.api.dataflow.value.IPredicateEvaluator;
import edu.uci.ics.hyracks.api.dataflow.value.IPredicateEvaluatorFactory;
import edu.uci.ics.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import edu.uci.ics.hyracks.api.dataflow.value.ITuplePartitionComputer;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.api.job.IOperatorDescriptorRegistry;
import edu.uci.ics.hyracks.api.job.JobId;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTuplePairComparator;
import edu.uci.ics.hyracks.dataflow.common.comm.util.FrameUtils;
import edu.uci.ics.hyracks.dataflow.common.data.partition.FieldHashPartitionComputerFactory;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractActivityNode;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractOperatorDescriptor;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractStateObject;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractUnaryInputSinkOperatorNodePushable;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractUnaryInputUnaryOutputOperatorNodePushable;
import edu.uci.ics.hyracks.dataflow.std.join.InMemoryHashJoin;
import edu.uci.ics.hyracks.dataflow.std.structures.SerializableHashTable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;

public class InMemoryHashJoinOperatorDescriptor
extends AbstractOperatorDescriptor {
    private static final long serialVersionUID = 1L;
    private final int[] keys0;
    private final int[] keys1;
    private final IBinaryHashFunctionFactory[] hashFunctionFactories;
    private final IBinaryComparatorFactory[] comparatorFactories;
    private final IPredicateEvaluatorFactory predEvaluatorFactory;
    private final boolean isLeftOuter;
    private final INullWriterFactory[] nullWriterFactories1;
    private final int tableSize;

    public InMemoryHashJoinOperatorDescriptor(IOperatorDescriptorRegistry spec, int[] keys0, int[] keys1, IBinaryHashFunctionFactory[] hashFunctionFactories, IBinaryComparatorFactory[] comparatorFactories, RecordDescriptor recordDescriptor, int tableSize, IPredicateEvaluatorFactory predEvalFactory) {
        super(spec, 2, 1);
        this.keys0 = keys0;
        this.keys1 = keys1;
        this.hashFunctionFactories = hashFunctionFactories;
        this.comparatorFactories = comparatorFactories;
        this.predEvaluatorFactory = predEvalFactory;
        this.recordDescriptors[0] = recordDescriptor;
        this.isLeftOuter = false;
        this.nullWriterFactories1 = null;
        this.tableSize = tableSize;
    }

    public InMemoryHashJoinOperatorDescriptor(IOperatorDescriptorRegistry spec, int[] keys0, int[] keys1, IBinaryHashFunctionFactory[] hashFunctionFactories, IBinaryComparatorFactory[] comparatorFactories, IPredicateEvaluatorFactory predEvalFactory, RecordDescriptor recordDescriptor, boolean isLeftOuter, INullWriterFactory[] nullWriterFactories1, int tableSize) {
        super(spec, 2, 1);
        this.keys0 = keys0;
        this.keys1 = keys1;
        this.hashFunctionFactories = hashFunctionFactories;
        this.comparatorFactories = comparatorFactories;
        this.predEvaluatorFactory = predEvalFactory;
        this.recordDescriptors[0] = recordDescriptor;
        this.isLeftOuter = isLeftOuter;
        this.nullWriterFactories1 = nullWriterFactories1;
        this.tableSize = tableSize;
    }

    public InMemoryHashJoinOperatorDescriptor(IOperatorDescriptorRegistry spec, int[] keys0, int[] keys1, IBinaryHashFunctionFactory[] hashFunctionFactories, IBinaryComparatorFactory[] comparatorFactories, RecordDescriptor recordDescriptor, int tableSize) {
        this(spec, keys0, keys1, hashFunctionFactories, comparatorFactories, recordDescriptor, tableSize, null);
    }

    public InMemoryHashJoinOperatorDescriptor(IOperatorDescriptorRegistry spec, int[] keys0, int[] keys1, IBinaryHashFunctionFactory[] hashFunctionFactories, IBinaryComparatorFactory[] comparatorFactories, RecordDescriptor recordDescriptor, boolean isLeftOuter, INullWriterFactory[] nullWriterFactories1, int tableSize) {
        this(spec, keys0, keys1, hashFunctionFactories, comparatorFactories, null, recordDescriptor, isLeftOuter, nullWriterFactories1, tableSize);
    }

    public void contributeActivities(IActivityGraphBuilder builder) {
        ActivityId hbaId = new ActivityId(this.odId, 0);
        ActivityId hpaId = new ActivityId(this.odId, 1);
        HashBuildActivityNode hba = new HashBuildActivityNode(hbaId, hpaId);
        HashProbeActivityNode hpa = new HashProbeActivityNode(hpaId);
        builder.addActivity((IOperatorDescriptor)this, (IActivity)hba);
        builder.addSourceEdge(1, (IActivity)hba, 0);
        builder.addActivity((IOperatorDescriptor)this, (IActivity)hpa);
        builder.addSourceEdge(0, (IActivity)hpa, 0);
        builder.addTargetEdge(0, (IActivity)hpa, 0);
        builder.addBlockingEdge((IActivity)hba, (IActivity)hpa);
    }

    private class HashProbeActivityNode
    extends AbstractActivityNode {
        private static final long serialVersionUID = 1L;

        public HashProbeActivityNode(ActivityId id) {
            super(id);
        }

        public IOperatorNodePushable createPushRuntime(final IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, final int partition, int nPartitions) {
            AbstractUnaryInputUnaryOutputOperatorNodePushable op = new AbstractUnaryInputUnaryOutputOperatorNodePushable(){
                private HashBuildTaskState state;

                public void open() throws HyracksDataException {
                    this.state = (HashBuildTaskState)ctx.getStateObject((Object)new TaskId(new ActivityId(InMemoryHashJoinOperatorDescriptor.this.getOperatorId(), 0), partition));
                    this.writer.open();
                }

                public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                    this.state.joiner.join(buffer, this.writer);
                }

                public void close() throws HyracksDataException {
                    this.state.joiner.closeJoin(this.writer);
                    this.writer.close();
                }

                public void fail() throws HyracksDataException {
                    this.writer.fail();
                }
            };
            return op;
        }
    }

    private class HashBuildActivityNode
    extends AbstractActivityNode {
        private static final long serialVersionUID = 1L;
        private final ActivityId hpaId;

        public HashBuildActivityNode(ActivityId id, ActivityId hpaId) {
            super(id);
            this.hpaId = hpaId;
        }

        public IOperatorNodePushable createPushRuntime(final IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, final int partition, int nPartitions) {
            INullWriter[] nullWriters1;
            final RecordDescriptor rd0 = recordDescProvider.getInputRecordDescriptor(this.hpaId, 0);
            final RecordDescriptor rd1 = recordDescProvider.getInputRecordDescriptor(this.getActivityId(), 0);
            final IBinaryComparator[] comparators = new IBinaryComparator[InMemoryHashJoinOperatorDescriptor.this.comparatorFactories.length];
            for (int i = 0; i < InMemoryHashJoinOperatorDescriptor.this.comparatorFactories.length; ++i) {
                comparators[i] = InMemoryHashJoinOperatorDescriptor.this.comparatorFactories[i].createBinaryComparator();
            }
            INullWriter[] iNullWriterArray = nullWriters1 = InMemoryHashJoinOperatorDescriptor.this.isLeftOuter ? new INullWriter[InMemoryHashJoinOperatorDescriptor.this.nullWriterFactories1.length] : null;
            if (InMemoryHashJoinOperatorDescriptor.this.isLeftOuter) {
                for (int i = 0; i < InMemoryHashJoinOperatorDescriptor.this.nullWriterFactories1.length; ++i) {
                    nullWriters1[i] = InMemoryHashJoinOperatorDescriptor.this.nullWriterFactories1[i].createNullWriter();
                }
            }
            final IPredicateEvaluator predEvaluator = InMemoryHashJoinOperatorDescriptor.this.predEvaluatorFactory == null ? null : InMemoryHashJoinOperatorDescriptor.this.predEvaluatorFactory.createPredicateEvaluator();
            AbstractUnaryInputSinkOperatorNodePushable op = new AbstractUnaryInputSinkOperatorNodePushable(){
                private HashBuildTaskState state;

                public void open() throws HyracksDataException {
                    ITuplePartitionComputer hpc0 = new FieldHashPartitionComputerFactory(InMemoryHashJoinOperatorDescriptor.this.keys0, InMemoryHashJoinOperatorDescriptor.this.hashFunctionFactories).createPartitioner();
                    ITuplePartitionComputer hpc1 = new FieldHashPartitionComputerFactory(InMemoryHashJoinOperatorDescriptor.this.keys1, InMemoryHashJoinOperatorDescriptor.this.hashFunctionFactories).createPartitioner();
                    this.state = new HashBuildTaskState(ctx.getJobletContext().getJobId(), new TaskId(HashBuildActivityNode.this.getActivityId(), partition));
                    SerializableHashTable table = new SerializableHashTable(InMemoryHashJoinOperatorDescriptor.this.tableSize, ctx);
                    this.state.joiner = new InMemoryHashJoin(ctx, InMemoryHashJoinOperatorDescriptor.this.tableSize, new FrameTupleAccessor(ctx.getFrameSize(), rd0), hpc0, new FrameTupleAccessor(ctx.getFrameSize(), rd1), hpc1, new FrameTuplePairComparator(InMemoryHashJoinOperatorDescriptor.this.keys0, InMemoryHashJoinOperatorDescriptor.this.keys1, comparators), InMemoryHashJoinOperatorDescriptor.this.isLeftOuter, nullWriters1, table, predEvaluator);
                }

                public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                    ByteBuffer copyBuffer = ctx.allocateFrame();
                    FrameUtils.copy((ByteBuffer)buffer, (ByteBuffer)copyBuffer);
                    this.state.joiner.build(copyBuffer);
                }

                public void close() throws HyracksDataException {
                    ctx.setStateObject((IStateObject)this.state);
                }

                public void fail() throws HyracksDataException {
                }
            };
            return op;
        }
    }

    public static class HashBuildTaskState
    extends AbstractStateObject {
        private InMemoryHashJoin joiner;

        public HashBuildTaskState() {
        }

        private HashBuildTaskState(JobId jobId, TaskId taskId) {
            super(jobId, taskId);
        }

        public void toBytes(DataOutput out) throws IOException {
        }

        public void fromBytes(DataInput in) throws IOException {
        }
    }
}

