/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.std.join;

import edu.uci.ics.hyracks.api.comm.IFrameTupleAccessor;
import edu.uci.ics.hyracks.api.comm.IFrameWriter;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.value.INullWriter;
import edu.uci.ics.hyracks.api.dataflow.value.IPredicateEvaluator;
import edu.uci.ics.hyracks.api.dataflow.value.ITuplePartitionComputer;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTuplePairComparator;
import edu.uci.ics.hyracks.dataflow.std.structures.ISerializableTable;
import edu.uci.ics.hyracks.dataflow.std.structures.TuplePointer;
import java.io.DataOutput;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class InMemoryHashJoin {
    private final IHyracksTaskContext ctx;
    private final List<ByteBuffer> buffers;
    private final FrameTupleAccessor accessorBuild;
    private final ITuplePartitionComputer tpcBuild;
    private final FrameTupleAccessor accessorProbe;
    private final ITuplePartitionComputer tpcProbe;
    private final FrameTupleAppender appender;
    private final FrameTuplePairComparator tpComparator;
    private final ByteBuffer outBuffer;
    private final boolean isLeftOuter;
    private final ArrayTupleBuilder nullTupleBuild;
    private final ISerializableTable table;
    private final int tableSize;
    private final TuplePointer storedTuplePointer;
    private final boolean reverseOutputOrder;
    private final IPredicateEvaluator predEvaluator;

    public InMemoryHashJoin(IHyracksTaskContext ctx, int tableSize, FrameTupleAccessor accessor0, ITuplePartitionComputer tpc0, FrameTupleAccessor accessor1, ITuplePartitionComputer tpc1, FrameTuplePairComparator comparator, boolean isLeftOuter, INullWriter[] nullWriters1, ISerializableTable table, IPredicateEvaluator predEval) throws HyracksDataException {
        this(ctx, tableSize, accessor0, tpc0, accessor1, tpc1, comparator, isLeftOuter, nullWriters1, table, predEval, false);
    }

    public InMemoryHashJoin(IHyracksTaskContext ctx, int tableSize, FrameTupleAccessor accessor0, ITuplePartitionComputer tpc0, FrameTupleAccessor accessor1, ITuplePartitionComputer tpc1, FrameTuplePairComparator comparator, boolean isLeftOuter, INullWriter[] nullWriters1, ISerializableTable table, IPredicateEvaluator predEval, boolean reverse) throws HyracksDataException {
        this.ctx = ctx;
        this.tableSize = tableSize;
        this.table = table;
        this.storedTuplePointer = new TuplePointer();
        this.buffers = new ArrayList<ByteBuffer>();
        this.accessorBuild = accessor1;
        this.tpcBuild = tpc1;
        this.accessorProbe = accessor0;
        this.tpcProbe = tpc0;
        this.appender = new FrameTupleAppender(ctx.getFrameSize());
        this.tpComparator = comparator;
        this.outBuffer = ctx.allocateFrame();
        this.appender.reset(this.outBuffer, true);
        this.predEvaluator = predEval;
        this.isLeftOuter = isLeftOuter;
        if (isLeftOuter) {
            int fieldCountOuter = accessor1.getFieldCount();
            this.nullTupleBuild = new ArrayTupleBuilder(fieldCountOuter);
            DataOutput out = this.nullTupleBuild.getDataOutput();
            for (int i = 0; i < fieldCountOuter; ++i) {
                nullWriters1[i].writeNull(out);
                this.nullTupleBuild.addFieldEndOffset();
            }
        } else {
            this.nullTupleBuild = null;
        }
        this.reverseOutputOrder = reverse;
    }

    public void build(ByteBuffer buffer) throws HyracksDataException {
        this.buffers.add(buffer);
        int bIndex = this.buffers.size() - 1;
        this.accessorBuild.reset(buffer);
        int tCount = this.accessorBuild.getTupleCount();
        int i = 0;
        while (i < tCount) {
            int entry = this.tpcBuild.partition((IFrameTupleAccessor)this.accessorBuild, i, this.tableSize);
            this.storedTuplePointer.frameIndex = bIndex;
            this.storedTuplePointer.tupleIndex = i++;
            this.table.insert(entry, this.storedTuplePointer);
        }
    }

    public void join(ByteBuffer buffer, IFrameWriter writer) throws HyracksDataException {
        this.accessorProbe.reset(buffer);
        int tupleCount0 = this.accessorProbe.getTupleCount();
        for (int i = 0; i < tupleCount0; ++i) {
            boolean matchFound = false;
            if (this.tableSize != 0) {
                int entry = this.tpcProbe.partition((IFrameTupleAccessor)this.accessorProbe, i, this.tableSize);
                int offset = 0;
                while (true) {
                    boolean predEval;
                    this.table.getTuplePointer(entry, offset++, this.storedTuplePointer);
                    if (this.storedTuplePointer.frameIndex < 0) break;
                    int bIndex = this.storedTuplePointer.frameIndex;
                    int tIndex = this.storedTuplePointer.tupleIndex;
                    this.accessorBuild.reset(this.buffers.get(bIndex));
                    int c = this.tpComparator.compare(this.accessorProbe, i, this.accessorBuild, tIndex);
                    if (c != 0 || !(predEval = this.evaluatePredicate(i, tIndex))) continue;
                    matchFound = true;
                    this.appendToResult(i, tIndex, writer);
                }
            }
            if (matchFound || !this.isLeftOuter || this.appender.appendConcat((IFrameTupleAccessor)this.accessorProbe, i, this.nullTupleBuild.getFieldEndOffsets(), this.nullTupleBuild.getByteArray(), 0, this.nullTupleBuild.getSize())) continue;
            this.flushFrame(this.outBuffer, writer);
            this.appender.reset(this.outBuffer, true);
            if (this.appender.appendConcat((IFrameTupleAccessor)this.accessorProbe, i, this.nullTupleBuild.getFieldEndOffsets(), this.nullTupleBuild.getByteArray(), 0, this.nullTupleBuild.getSize())) continue;
            throw new HyracksDataException("Record size larger than frame size (" + this.appender.getBuffer().capacity() + ")");
        }
    }

    public void closeJoin(IFrameWriter writer) throws HyracksDataException {
        if (this.appender.getTupleCount() > 0) {
            this.flushFrame(this.outBuffer, writer);
        }
        int nFrames = this.buffers.size();
        this.buffers.clear();
        this.ctx.deallocateFrames(nFrames);
    }

    private void flushFrame(ByteBuffer buffer, IFrameWriter writer) throws HyracksDataException {
        buffer.position(0);
        buffer.limit(buffer.capacity());
        writer.nextFrame(buffer);
        buffer.position(0);
        buffer.limit(buffer.capacity());
    }

    private boolean evaluatePredicate(int tIx1, int tIx2) {
        if (this.reverseOutputOrder) {
            return this.predEvaluator == null || this.predEvaluator.evaluate((IFrameTupleAccessor)this.accessorBuild, tIx2, (IFrameTupleAccessor)this.accessorProbe, tIx1);
        }
        return this.predEvaluator == null || this.predEvaluator.evaluate((IFrameTupleAccessor)this.accessorProbe, tIx1, (IFrameTupleAccessor)this.accessorBuild, tIx2);
    }

    private void appendToResult(int probeSidetIx, int buildSidetIx, IFrameWriter writer) throws HyracksDataException {
        if (!this.reverseOutputOrder) {
            if (!this.appender.appendConcat((IFrameTupleAccessor)this.accessorProbe, probeSidetIx, (IFrameTupleAccessor)this.accessorBuild, buildSidetIx)) {
                this.flushFrame(this.outBuffer, writer);
                this.appender.reset(this.outBuffer, true);
                if (!this.appender.appendConcat((IFrameTupleAccessor)this.accessorProbe, probeSidetIx, (IFrameTupleAccessor)this.accessorBuild, buildSidetIx)) {
                    int tSize = this.accessorProbe.getTupleEndOffset(probeSidetIx) - this.accessorProbe.getTupleStartOffset(probeSidetIx) + this.accessorBuild.getTupleEndOffset(buildSidetIx) - this.accessorBuild.getTupleStartOffset(buildSidetIx);
                    throw new HyracksDataException("Record size (" + tSize + ") larger than frame size (" + this.appender.getBuffer().capacity() + ")");
                }
            }
        } else if (!this.appender.appendConcat((IFrameTupleAccessor)this.accessorBuild, buildSidetIx, (IFrameTupleAccessor)this.accessorProbe, probeSidetIx)) {
            this.flushFrame(this.outBuffer, writer);
            this.appender.reset(this.outBuffer, true);
            if (!this.appender.appendConcat((IFrameTupleAccessor)this.accessorBuild, buildSidetIx, (IFrameTupleAccessor)this.accessorProbe, probeSidetIx)) {
                int tSize = this.accessorProbe.getTupleEndOffset(probeSidetIx) - this.accessorProbe.getTupleStartOffset(probeSidetIx) + this.accessorBuild.getTupleEndOffset(buildSidetIx) - this.accessorBuild.getTupleStartOffset(buildSidetIx);
                throw new HyracksDataException("Record size (" + tSize + ") larger than frame size (" + this.appender.getBuffer().capacity() + ")");
            }
        }
    }
}

