/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.std.join;

import edu.uci.ics.hyracks.api.comm.IFrameTupleAccessor;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.ActivityId;
import edu.uci.ics.hyracks.api.dataflow.IActivity;
import edu.uci.ics.hyracks.api.dataflow.IActivityGraphBuilder;
import edu.uci.ics.hyracks.api.dataflow.IOperatorDescriptor;
import edu.uci.ics.hyracks.api.dataflow.IOperatorNodePushable;
import edu.uci.ics.hyracks.api.dataflow.TaskId;
import edu.uci.ics.hyracks.api.dataflow.state.IStateObject;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryComparator;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryHashFunctionFactory;
import edu.uci.ics.hyracks.api.dataflow.value.INullWriter;
import edu.uci.ics.hyracks.api.dataflow.value.INullWriterFactory;
import edu.uci.ics.hyracks.api.dataflow.value.IPredicateEvaluator;
import edu.uci.ics.hyracks.api.dataflow.value.IPredicateEvaluatorFactory;
import edu.uci.ics.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import edu.uci.ics.hyracks.api.dataflow.value.ITuplePartitionComputer;
import edu.uci.ics.hyracks.api.dataflow.value.ITuplePartitionComputerFactory;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.api.io.FileReference;
import edu.uci.ics.hyracks.api.job.IOperatorDescriptorRegistry;
import edu.uci.ics.hyracks.api.job.JobId;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTuplePairComparator;
import edu.uci.ics.hyracks.dataflow.common.comm.util.FrameUtils;
import edu.uci.ics.hyracks.dataflow.common.data.partition.FieldHashPartitionComputerFactory;
import edu.uci.ics.hyracks.dataflow.common.data.partition.RepartitionComputerFactory;
import edu.uci.ics.hyracks.dataflow.common.io.RunFileReader;
import edu.uci.ics.hyracks.dataflow.common.io.RunFileWriter;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractActivityNode;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractOperatorDescriptor;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractStateObject;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractUnaryInputSinkOperatorNodePushable;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractUnaryInputUnaryOutputOperatorNodePushable;
import edu.uci.ics.hyracks.dataflow.std.join.InMemoryHashJoin;
import edu.uci.ics.hyracks.dataflow.std.structures.SerializableHashTable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;

public class HybridHashJoinOperatorDescriptor
extends AbstractOperatorDescriptor {
    private static final int BUILD_AND_PARTITION_ACTIVITY_ID = 0;
    private static final int PARTITION_AND_JOIN_ACTIVITY_ID = 1;
    private final int memsize;
    private static final long serialVersionUID = 1L;
    private final int inputsize0;
    private final double factor;
    private final int recordsPerFrame;
    private final int[] keys0;
    private final int[] keys1;
    private final IBinaryHashFunctionFactory[] hashFunctionFactories;
    private final IBinaryComparatorFactory[] comparatorFactories;
    private final IPredicateEvaluatorFactory predEvaluatorFactory;
    private final boolean isLeftOuter;
    private final INullWriterFactory[] nullWriterFactories1;

    public HybridHashJoinOperatorDescriptor(IOperatorDescriptorRegistry spec, int memsize, int inputsize0, int recordsPerFrame, double factor, int[] keys0, int[] keys1, IBinaryHashFunctionFactory[] hashFunctionFactories, IBinaryComparatorFactory[] comparatorFactories, RecordDescriptor recordDescriptor, IPredicateEvaluatorFactory predEvalFactory) throws HyracksDataException {
        super(spec, 2, 1);
        this.memsize = memsize;
        this.inputsize0 = inputsize0;
        this.factor = factor;
        this.recordsPerFrame = recordsPerFrame;
        this.keys0 = keys0;
        this.keys1 = keys1;
        this.hashFunctionFactories = hashFunctionFactories;
        this.comparatorFactories = comparatorFactories;
        this.predEvaluatorFactory = predEvalFactory;
        this.isLeftOuter = false;
        this.nullWriterFactories1 = null;
        this.recordDescriptors[0] = recordDescriptor;
    }

    public HybridHashJoinOperatorDescriptor(IOperatorDescriptorRegistry spec, int memsize, int inputsize0, int recordsPerFrame, double factor, int[] keys0, int[] keys1, IBinaryHashFunctionFactory[] hashFunctionFactories, IBinaryComparatorFactory[] comparatorFactories, RecordDescriptor recordDescriptor, IPredicateEvaluatorFactory predEvalFactory, boolean isLeftOuter, INullWriterFactory[] nullWriterFactories1) throws HyracksDataException {
        super(spec, 2, 1);
        this.memsize = memsize;
        this.inputsize0 = inputsize0;
        this.factor = factor;
        this.recordsPerFrame = recordsPerFrame;
        this.keys0 = keys0;
        this.keys1 = keys1;
        this.hashFunctionFactories = hashFunctionFactories;
        this.comparatorFactories = comparatorFactories;
        this.predEvaluatorFactory = predEvalFactory;
        this.isLeftOuter = isLeftOuter;
        this.nullWriterFactories1 = nullWriterFactories1;
        this.recordDescriptors[0] = recordDescriptor;
    }

    public void contributeActivities(IActivityGraphBuilder builder) {
        ActivityId p1Aid = new ActivityId(this.odId, 0);
        ActivityId p2Aid = new ActivityId(this.odId, 1);
        BuildAndPartitionActivityNode phase1 = new BuildAndPartitionActivityNode(p1Aid, p2Aid);
        PartitionAndJoinActivityNode phase2 = new PartitionAndJoinActivityNode(p2Aid, p1Aid);
        builder.addActivity((IOperatorDescriptor)this, (IActivity)phase1);
        builder.addSourceEdge(1, (IActivity)phase1, 0);
        builder.addActivity((IOperatorDescriptor)this, (IActivity)phase2);
        builder.addSourceEdge(0, (IActivity)phase2, 0);
        builder.addBlockingEdge((IActivity)phase1, (IActivity)phase2);
        builder.addTargetEdge(0, (IActivity)phase2, 0);
    }

    private class PartitionAndJoinActivityNode
    extends AbstractActivityNode {
        private static final long serialVersionUID = 1L;
        private final ActivityId buildAid;

        public PartitionAndJoinActivityNode(ActivityId id, ActivityId buildAid) {
            super(id);
            this.buildAid = buildAid;
        }

        public IOperatorNodePushable createPushRuntime(final IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, final int partition, final int nPartitions) throws HyracksDataException {
            INullWriter[] nullWriters1;
            final RecordDescriptor rd0 = recordDescProvider.getInputRecordDescriptor(this.getActivityId(), 0);
            final RecordDescriptor rd1 = recordDescProvider.getInputRecordDescriptor(this.buildAid, 0);
            final IBinaryComparator[] comparators = new IBinaryComparator[HybridHashJoinOperatorDescriptor.this.comparatorFactories.length];
            for (int i = 0; i < HybridHashJoinOperatorDescriptor.this.comparatorFactories.length; ++i) {
                comparators[i] = HybridHashJoinOperatorDescriptor.this.comparatorFactories[i].createBinaryComparator();
            }
            INullWriter[] iNullWriterArray = nullWriters1 = HybridHashJoinOperatorDescriptor.this.isLeftOuter ? new INullWriter[HybridHashJoinOperatorDescriptor.this.nullWriterFactories1.length] : null;
            if (HybridHashJoinOperatorDescriptor.this.isLeftOuter) {
                for (int i = 0; i < HybridHashJoinOperatorDescriptor.this.nullWriterFactories1.length; ++i) {
                    nullWriters1[i] = HybridHashJoinOperatorDescriptor.this.nullWriterFactories1[i].createNullWriter();
                }
            }
            final IPredicateEvaluator predEvaluator = HybridHashJoinOperatorDescriptor.this.predEvaluatorFactory == null ? null : HybridHashJoinOperatorDescriptor.this.predEvaluatorFactory.createPredicateEvaluator();
            AbstractUnaryInputUnaryOutputOperatorNodePushable op = new AbstractUnaryInputUnaryOutputOperatorNodePushable(){
                private BuildAndPartitionTaskState state;
                private final FrameTupleAccessor accessorProbe;
                private final ITuplePartitionComputerFactory hpcf0;
                private final ITuplePartitionComputerFactory hpcf1;
                private final ITuplePartitionComputer hpcProbe;
                private final FrameTupleAppender appender;
                private final FrameTupleAppender ftap;
                private final ByteBuffer inBuffer;
                private final ByteBuffer outBuffer;
                private RunFileWriter[] buildWriters;
                private RunFileWriter[] probeWriters;
                private ByteBuffer[] bufferForPartitions;
                {
                    this.accessorProbe = new FrameTupleAccessor(ctx.getFrameSize(), rd0);
                    this.hpcf0 = new FieldHashPartitionComputerFactory(HybridHashJoinOperatorDescriptor.this.keys0, HybridHashJoinOperatorDescriptor.this.hashFunctionFactories);
                    this.hpcf1 = new FieldHashPartitionComputerFactory(HybridHashJoinOperatorDescriptor.this.keys1, HybridHashJoinOperatorDescriptor.this.hashFunctionFactories);
                    this.hpcProbe = this.hpcf0.createPartitioner();
                    this.appender = new FrameTupleAppender(ctx.getFrameSize());
                    this.ftap = new FrameTupleAppender(ctx.getFrameSize());
                    this.inBuffer = ctx.allocateFrame();
                    this.outBuffer = ctx.allocateFrame();
                }

                public void open() throws HyracksDataException {
                    this.state = (BuildAndPartitionTaskState)ctx.getStateObject((Object)new TaskId(new ActivityId(HybridHashJoinOperatorDescriptor.this.getOperatorId(), 0), partition));
                    this.writer.open();
                    this.buildWriters = this.state.fWriters;
                    this.probeWriters = new RunFileWriter[this.state.nPartitions];
                    this.bufferForPartitions = new ByteBuffer[this.state.nPartitions];
                    for (int i = 0; i < this.state.nPartitions; ++i) {
                        this.bufferForPartitions[i] = ctx.allocateFrame();
                    }
                    this.appender.reset(this.outBuffer, true);
                    this.ftap.reset(this.inBuffer, true);
                }

                public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                    if (this.state.memoryForHashtable != HybridHashJoinOperatorDescriptor.this.memsize - 2) {
                        this.accessorProbe.reset(buffer);
                        int tupleCount0 = this.accessorProbe.getTupleCount();
                        block0: for (int i = 0; i < tupleCount0; ++i) {
                            ByteBuffer outbuf;
                            boolean newBuffer;
                            int entry = -1;
                            if (this.state.memoryForHashtable == 0) {
                                entry = this.hpcProbe.partition((IFrameTupleAccessor)this.accessorProbe, i, this.state.nPartitions);
                                newBuffer = false;
                                outbuf = this.bufferForPartitions[entry];
                                while (true) {
                                    this.appender.reset(outbuf, newBuffer);
                                    if (this.appender.append((IFrameTupleAccessor)this.accessorProbe, i)) continue block0;
                                    this.write(entry, outbuf);
                                    outbuf.clear();
                                    newBuffer = true;
                                }
                            }
                            entry = this.hpcProbe.partition((IFrameTupleAccessor)this.accessorProbe, i, (int)((double)HybridHashJoinOperatorDescriptor.this.inputsize0 * HybridHashJoinOperatorDescriptor.this.factor / (double)nPartitions));
                            if (entry < this.state.memoryForHashtable) {
                                while (!this.ftap.append((IFrameTupleAccessor)this.accessorProbe, i)) {
                                    this.state.joiner.join(this.inBuffer, this.writer);
                                    this.ftap.reset(this.inBuffer, true);
                                }
                                continue;
                            }
                            newBuffer = false;
                            outbuf = this.bufferForPartitions[entry %= this.state.nPartitions];
                            while (true) {
                                this.appender.reset(outbuf, newBuffer);
                                if (this.appender.append((IFrameTupleAccessor)this.accessorProbe, i)) continue block0;
                                this.write(entry, outbuf);
                                outbuf.clear();
                                newBuffer = true;
                            }
                        }
                    } else {
                        this.state.joiner.join(buffer, this.writer);
                    }
                }

                public void close() throws HyracksDataException {
                    this.state.joiner.join(this.inBuffer, this.writer);
                    this.state.joiner.closeJoin(this.writer);
                    ITuplePartitionComputer hpcRep0 = new RepartitionComputerFactory(this.state.nPartitions, this.hpcf0).createPartitioner();
                    ITuplePartitionComputer hpcRep1 = new RepartitionComputerFactory(this.state.nPartitions, this.hpcf1).createPartitioner();
                    if (this.state.memoryForHashtable != HybridHashJoinOperatorDescriptor.this.memsize - 2) {
                        for (int i = 0; i < this.state.nPartitions; ++i) {
                            ByteBuffer buf = this.bufferForPartitions[i];
                            this.accessorProbe.reset(buf);
                            if (this.accessorProbe.getTupleCount() > 0) {
                                this.write(i, buf);
                            }
                            this.closeWriter(i);
                        }
                        this.inBuffer.clear();
                        int tableSize = -1;
                        tableSize = this.state.memoryForHashtable == 0 ? (int)((double)(this.state.nPartitions * HybridHashJoinOperatorDescriptor.this.recordsPerFrame) * HybridHashJoinOperatorDescriptor.this.factor) : (int)((double)(HybridHashJoinOperatorDescriptor.this.memsize * HybridHashJoinOperatorDescriptor.this.recordsPerFrame) * HybridHashJoinOperatorDescriptor.this.factor);
                        for (int partitionid = 0; partitionid < this.state.nPartitions; ++partitionid) {
                            RunFileWriter buildWriter = this.buildWriters[partitionid];
                            RunFileWriter probeWriter = this.probeWriters[partitionid];
                            if (buildWriter == null && !HybridHashJoinOperatorDescriptor.this.isLeftOuter || probeWriter == null) continue;
                            SerializableHashTable table = new SerializableHashTable(tableSize, ctx);
                            InMemoryHashJoin joiner = new InMemoryHashJoin(ctx, tableSize, new FrameTupleAccessor(ctx.getFrameSize(), rd0), hpcRep0, new FrameTupleAccessor(ctx.getFrameSize(), rd1), hpcRep1, new FrameTuplePairComparator(HybridHashJoinOperatorDescriptor.this.keys0, HybridHashJoinOperatorDescriptor.this.keys1, comparators), HybridHashJoinOperatorDescriptor.this.isLeftOuter, nullWriters1, table, predEvaluator);
                            if (buildWriter != null) {
                                RunFileReader buildReader = buildWriter.createReader();
                                buildReader.open();
                                while (buildReader.nextFrame(this.inBuffer)) {
                                    ByteBuffer copyBuffer = ctx.allocateFrame();
                                    FrameUtils.copy((ByteBuffer)this.inBuffer, (ByteBuffer)copyBuffer);
                                    joiner.build(copyBuffer);
                                    this.inBuffer.clear();
                                }
                                buildReader.close();
                            }
                            RunFileReader probeReader = probeWriter.createReader();
                            probeReader.open();
                            while (probeReader.nextFrame(this.inBuffer)) {
                                joiner.join(this.inBuffer, this.writer);
                                this.inBuffer.clear();
                            }
                            probeReader.close();
                            joiner.closeJoin(this.writer);
                        }
                    }
                    this.writer.close();
                }

                private void closeWriter(int i) throws HyracksDataException {
                    RunFileWriter writer = this.probeWriters[i];
                    if (writer != null) {
                        writer.close();
                    }
                }

                private void write(int i, ByteBuffer head) throws HyracksDataException {
                    RunFileWriter writer = this.probeWriters[i];
                    if (writer == null) {
                        FileReference file = ctx.createManagedWorkspaceFile(PartitionAndJoinActivityNode.class.getSimpleName());
                        writer = new RunFileWriter(file, ctx.getIOManager());
                        writer.open();
                        this.probeWriters[i] = writer;
                    }
                    writer.nextFrame(head);
                }

                public void fail() throws HyracksDataException {
                    this.writer.fail();
                }
            };
            return op;
        }
    }

    private class BuildAndPartitionActivityNode
    extends AbstractActivityNode {
        private static final long serialVersionUID = 1L;
        private final ActivityId joinAid;

        public BuildAndPartitionActivityNode(ActivityId id, ActivityId joinAid) {
            super(id);
            this.joinAid = joinAid;
        }

        public IOperatorNodePushable createPushRuntime(final IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, final int partition, final int nPartitions) throws HyracksDataException {
            INullWriter[] nullWriters1;
            final RecordDescriptor rd0 = recordDescProvider.getInputRecordDescriptor(this.joinAid, 0);
            final RecordDescriptor rd1 = recordDescProvider.getInputRecordDescriptor(this.getActivityId(), 0);
            final IBinaryComparator[] comparators = new IBinaryComparator[HybridHashJoinOperatorDescriptor.this.comparatorFactories.length];
            for (int i = 0; i < HybridHashJoinOperatorDescriptor.this.comparatorFactories.length; ++i) {
                comparators[i] = HybridHashJoinOperatorDescriptor.this.comparatorFactories[i].createBinaryComparator();
            }
            INullWriter[] iNullWriterArray = nullWriters1 = HybridHashJoinOperatorDescriptor.this.isLeftOuter ? new INullWriter[HybridHashJoinOperatorDescriptor.this.nullWriterFactories1.length] : null;
            if (HybridHashJoinOperatorDescriptor.this.isLeftOuter) {
                for (int i = 0; i < HybridHashJoinOperatorDescriptor.this.nullWriterFactories1.length; ++i) {
                    nullWriters1[i] = HybridHashJoinOperatorDescriptor.this.nullWriterFactories1[i].createNullWriter();
                }
            }
            final IPredicateEvaluator predEvaluator = HybridHashJoinOperatorDescriptor.this.predEvaluatorFactory == null ? null : HybridHashJoinOperatorDescriptor.this.predEvaluatorFactory.createPredicateEvaluator();
            AbstractUnaryInputSinkOperatorNodePushable op = new AbstractUnaryInputSinkOperatorNodePushable(){
                private BuildAndPartitionTaskState state;
                private final FrameTupleAccessor accessorBuild;
                private final ITuplePartitionComputer hpcBuild;
                private final FrameTupleAppender appender;
                private final FrameTupleAppender ftappender;
                private ByteBuffer[] bufferForPartitions;
                private final ByteBuffer inBuffer;
                {
                    this.state = new BuildAndPartitionTaskState(ctx.getJobletContext().getJobId(), new TaskId(BuildAndPartitionActivityNode.this.getActivityId(), partition));
                    this.accessorBuild = new FrameTupleAccessor(ctx.getFrameSize(), rd1);
                    this.hpcBuild = new FieldHashPartitionComputerFactory(HybridHashJoinOperatorDescriptor.this.keys1, HybridHashJoinOperatorDescriptor.this.hashFunctionFactories).createPartitioner();
                    this.appender = new FrameTupleAppender(ctx.getFrameSize());
                    this.ftappender = new FrameTupleAppender(ctx.getFrameSize());
                    this.inBuffer = ctx.allocateFrame();
                }

                public void close() throws HyracksDataException {
                    if (this.state.memoryForHashtable != 0) {
                        this.build(this.inBuffer);
                    }
                    for (int i = 0; i < this.state.nPartitions; ++i) {
                        ByteBuffer buf = this.bufferForPartitions[i];
                        this.accessorBuild.reset(buf);
                        if (this.accessorBuild.getTupleCount() > 0) {
                            this.write(i, buf);
                        }
                        this.closeWriter(i);
                    }
                    ctx.setStateObject((IStateObject)this.state);
                }

                public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                    if (this.state.memoryForHashtable != HybridHashJoinOperatorDescriptor.this.memsize - 2) {
                        this.accessorBuild.reset(buffer);
                        int tCount = this.accessorBuild.getTupleCount();
                        block0: for (int i = 0; i < tCount; ++i) {
                            ByteBuffer bufBi;
                            boolean newBuffer;
                            int entry = -1;
                            if (this.state.memoryForHashtable == 0) {
                                entry = this.hpcBuild.partition((IFrameTupleAccessor)this.accessorBuild, i, this.state.nPartitions);
                                newBuffer = false;
                                bufBi = this.bufferForPartitions[entry];
                                while (true) {
                                    this.appender.reset(bufBi, newBuffer);
                                    if (this.appender.append((IFrameTupleAccessor)this.accessorBuild, i)) continue block0;
                                    this.write(entry, bufBi);
                                    bufBi.clear();
                                    newBuffer = true;
                                }
                            }
                            entry = this.hpcBuild.partition((IFrameTupleAccessor)this.accessorBuild, i, (int)((double)HybridHashJoinOperatorDescriptor.this.inputsize0 * HybridHashJoinOperatorDescriptor.this.factor / (double)nPartitions));
                            if (entry < this.state.memoryForHashtable) {
                                while (!this.ftappender.append((IFrameTupleAccessor)this.accessorBuild, i)) {
                                    this.build(this.inBuffer);
                                    this.ftappender.reset(this.inBuffer, true);
                                }
                                continue;
                            }
                            newBuffer = false;
                            bufBi = this.bufferForPartitions[entry %= this.state.nPartitions];
                            while (true) {
                                this.appender.reset(bufBi, newBuffer);
                                if (this.appender.append((IFrameTupleAccessor)this.accessorBuild, i)) continue block0;
                                this.write(entry, bufBi);
                                bufBi.clear();
                                newBuffer = true;
                            }
                        }
                    } else {
                        this.build(buffer);
                    }
                }

                private void build(ByteBuffer inBuffer) throws HyracksDataException {
                    ByteBuffer copyBuffer = ctx.allocateFrame();
                    FrameUtils.copy((ByteBuffer)inBuffer, (ByteBuffer)copyBuffer);
                    this.state.joiner.build(copyBuffer);
                }

                public void open() throws HyracksDataException {
                    if (HybridHashJoinOperatorDescriptor.this.memsize > 1) {
                        if (HybridHashJoinOperatorDescriptor.this.memsize > HybridHashJoinOperatorDescriptor.this.inputsize0) {
                            this.state.nPartitions = 0;
                        } else {
                            this.state.nPartitions = (int)Math.ceil(((double)HybridHashJoinOperatorDescriptor.this.inputsize0 * HybridHashJoinOperatorDescriptor.this.factor / (double)nPartitions - (double)HybridHashJoinOperatorDescriptor.this.memsize) / (double)(HybridHashJoinOperatorDescriptor.this.memsize - 1));
                        }
                        if (this.state.nPartitions <= 0) {
                            this.state.memoryForHashtable = HybridHashJoinOperatorDescriptor.this.memsize - 2;
                            this.state.nPartitions = 0;
                        } else {
                            this.state.memoryForHashtable = HybridHashJoinOperatorDescriptor.this.memsize - this.state.nPartitions - 2;
                            if (this.state.memoryForHashtable < 0) {
                                this.state.memoryForHashtable = 0;
                                this.state.nPartitions = (int)Math.ceil(Math.sqrt((double)HybridHashJoinOperatorDescriptor.this.inputsize0 * HybridHashJoinOperatorDescriptor.this.factor / (double)nPartitions));
                            }
                        }
                    } else {
                        throw new HyracksDataException("not enough memory");
                    }
                    ITuplePartitionComputer hpc0 = new FieldHashPartitionComputerFactory(HybridHashJoinOperatorDescriptor.this.keys0, HybridHashJoinOperatorDescriptor.this.hashFunctionFactories).createPartitioner();
                    ITuplePartitionComputer hpc1 = new FieldHashPartitionComputerFactory(HybridHashJoinOperatorDescriptor.this.keys1, HybridHashJoinOperatorDescriptor.this.hashFunctionFactories).createPartitioner();
                    int tableSize = (int)((double)(this.state.memoryForHashtable * HybridHashJoinOperatorDescriptor.this.recordsPerFrame) * HybridHashJoinOperatorDescriptor.this.factor);
                    SerializableHashTable table = new SerializableHashTable(tableSize, ctx);
                    this.state.joiner = new InMemoryHashJoin(ctx, tableSize, new FrameTupleAccessor(ctx.getFrameSize(), rd0), hpc0, new FrameTupleAccessor(ctx.getFrameSize(), rd1), hpc1, new FrameTuplePairComparator(HybridHashJoinOperatorDescriptor.this.keys0, HybridHashJoinOperatorDescriptor.this.keys1, comparators), HybridHashJoinOperatorDescriptor.this.isLeftOuter, nullWriters1, table, predEvaluator);
                    this.bufferForPartitions = new ByteBuffer[this.state.nPartitions];
                    BuildAndPartitionTaskState.access$1502(this.state, new RunFileWriter[this.state.nPartitions]);
                    for (int i = 0; i < this.state.nPartitions; ++i) {
                        this.bufferForPartitions[i] = ctx.allocateFrame();
                    }
                    this.ftappender.reset(this.inBuffer, true);
                }

                public void fail() throws HyracksDataException {
                }

                private void closeWriter(int i) throws HyracksDataException {
                    RunFileWriter writer = this.state.fWriters[i];
                    if (writer != null) {
                        writer.close();
                    }
                }

                private void write(int i, ByteBuffer head) throws HyracksDataException {
                    RunFileWriter writer = this.state.fWriters[i];
                    if (writer == null) {
                        FileReference file = ctx.getJobletContext().createManagedWorkspaceFile(BuildAndPartitionActivityNode.class.getSimpleName());
                        writer = new RunFileWriter(file, ctx.getIOManager());
                        writer.open();
                        ((BuildAndPartitionTaskState)this.state).fWriters[i] = writer;
                    }
                    writer.nextFrame(head);
                }
            };
            return op;
        }
    }

    public static class BuildAndPartitionTaskState
    extends AbstractStateObject {
        private RunFileWriter[] fWriters;
        private InMemoryHashJoin joiner;
        private int nPartitions;
        private int memoryForHashtable;

        public BuildAndPartitionTaskState() {
        }

        private BuildAndPartitionTaskState(JobId jobId, TaskId taskId) {
            super(jobId, taskId);
        }

        public void toBytes(DataOutput out) throws IOException {
        }

        public void fromBytes(DataInput in) throws IOException {
        }

        static /* synthetic */ RunFileWriter[] access$1502(BuildAndPartitionTaskState x0, RunFileWriter[] x1) {
            x0.fWriters = x1;
            return x1;
        }
    }
}

