/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.std.join;

import edu.uci.ics.hyracks.api.comm.IFrameTupleAccessor;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.state.IStateObject;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryComparator;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryHashFunctionFactory;
import edu.uci.ics.hyracks.api.dataflow.value.ITuplePartitionComputer;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.api.io.FileReference;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import edu.uci.ics.hyracks.dataflow.common.data.partition.FieldHashPartitionComputerFactory;
import edu.uci.ics.hyracks.dataflow.common.io.RunFileWriter;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractUnaryInputSinkOperatorNodePushable;
import edu.uci.ics.hyracks.dataflow.std.join.GraceHashJoinOperatorDescriptor;
import edu.uci.ics.hyracks.dataflow.std.join.GraceHashJoinPartitionState;
import java.nio.ByteBuffer;

class GraceHashJoinPartitionBuildOperatorNodePushable
extends AbstractUnaryInputSinkOperatorNodePushable {
    private final IHyracksTaskContext ctx;
    private final Object stateId;
    private final int numPartitions;
    private final IBinaryComparator[] comparators;
    private final FrameTupleAccessor accessor0;
    private final ITuplePartitionComputer hpc;
    private final FrameTupleAppender appender;
    private ByteBuffer[] outbufs;
    private GraceHashJoinPartitionState state;

    GraceHashJoinPartitionBuildOperatorNodePushable(IHyracksTaskContext ctx, Object stateId, int[] keys, IBinaryHashFunctionFactory[] hashFunctionFactories, IBinaryComparatorFactory[] comparatorFactories, int numPartitions, RecordDescriptor inRecordDescriptor) {
        this.ctx = ctx;
        this.stateId = stateId;
        this.numPartitions = numPartitions;
        this.accessor0 = new FrameTupleAccessor(ctx.getFrameSize(), inRecordDescriptor);
        this.appender = new FrameTupleAppender(ctx.getFrameSize());
        this.hpc = new FieldHashPartitionComputerFactory(keys, hashFunctionFactories).createPartitioner();
        this.comparators = new IBinaryComparator[comparatorFactories.length];
        for (int i = 0; i < comparatorFactories.length; ++i) {
            this.comparators[i] = comparatorFactories[i].createBinaryComparator();
        }
    }

    public void close() throws HyracksDataException {
        for (int i = 0; i < this.numPartitions; ++i) {
            ByteBuffer head = this.outbufs[i];
            this.accessor0.reset(head);
            if (this.accessor0.getTupleCount() > 0) {
                this.write(i, head);
            }
            this.closeWriter(i);
        }
        this.ctx.setStateObject((IStateObject)this.state);
    }

    private void closeWriter(int i) throws HyracksDataException {
        RunFileWriter writer = this.state.getRunWriters()[i];
        if (writer != null) {
            writer.close();
        }
    }

    private void write(int i, ByteBuffer head) throws HyracksDataException {
        RunFileWriter writer = this.state.getRunWriters()[i];
        if (writer == null) {
            FileReference file = this.ctx.getJobletContext().createManagedWorkspaceFile(GraceHashJoinOperatorDescriptor.class.getSimpleName());
            writer = new RunFileWriter(file, this.ctx.getIOManager());
            writer.open();
            this.state.getRunWriters()[i] = writer;
        }
        writer.nextFrame(head);
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.accessor0.reset(buffer);
        int tCount = this.accessor0.getTupleCount();
        for (int i = 0; i < tCount; ++i) {
            int entry = this.hpc.partition((IFrameTupleAccessor)this.accessor0, i, this.numPartitions);
            ByteBuffer outbuf = this.outbufs[entry];
            this.appender.reset(outbuf, false);
            if (this.appender.append((IFrameTupleAccessor)this.accessor0, i)) continue;
            this.write(entry, outbuf);
            outbuf.clear();
            this.appender.reset(outbuf, true);
            if (this.appender.append((IFrameTupleAccessor)this.accessor0, i)) continue;
            throw new HyracksDataException("Item too big to fit in frame");
        }
    }

    public void open() throws HyracksDataException {
        this.state = new GraceHashJoinPartitionState(this.ctx.getJobletContext().getJobId(), this.stateId);
        this.outbufs = new ByteBuffer[this.numPartitions];
        this.state.setRunWriters(new RunFileWriter[this.numPartitions]);
        for (int i = 0; i < this.numPartitions; ++i) {
            this.outbufs[i] = this.ctx.allocateFrame();
        }
    }

    public void fail() throws HyracksDataException {
    }
}

