/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.std.join;

import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryComparator;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryHashFunctionFactory;
import edu.uci.ics.hyracks.api.dataflow.value.INullWriter;
import edu.uci.ics.hyracks.api.dataflow.value.INullWriterFactory;
import edu.uci.ics.hyracks.api.dataflow.value.IPredicateEvaluator;
import edu.uci.ics.hyracks.api.dataflow.value.ITuplePartitionComputer;
import edu.uci.ics.hyracks.api.dataflow.value.ITuplePartitionComputerFactory;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTuplePairComparator;
import edu.uci.ics.hyracks.dataflow.common.comm.util.FrameUtils;
import edu.uci.ics.hyracks.dataflow.common.data.partition.FieldHashPartitionComputerFactory;
import edu.uci.ics.hyracks.dataflow.common.data.partition.RepartitionComputerFactory;
import edu.uci.ics.hyracks.dataflow.common.io.RunFileReader;
import edu.uci.ics.hyracks.dataflow.common.io.RunFileWriter;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractUnaryOutputSourceOperatorNodePushable;
import edu.uci.ics.hyracks.dataflow.std.join.GraceHashJoinPartitionState;
import edu.uci.ics.hyracks.dataflow.std.join.InMemoryHashJoin;
import edu.uci.ics.hyracks.dataflow.std.structures.SerializableHashTable;
import java.nio.ByteBuffer;

class GraceHashJoinOperatorNodePushable
extends AbstractUnaryOutputSourceOperatorNodePushable {
    private final IHyracksTaskContext ctx;
    private final Object state0Id;
    private final Object state1Id;
    private final int[] keys0;
    private final int[] keys1;
    private final IBinaryHashFunctionFactory[] hashFunctionFactories;
    private final IBinaryComparatorFactory[] comparatorFactories;
    private final INullWriterFactory[] nullWriterFactories;
    private final RecordDescriptor rd0;
    private final RecordDescriptor rd1;
    private final int recordsPerFrame;
    private final double factor;
    private final int numPartitions;
    private final boolean isLeftOuter;
    private final IPredicateEvaluator predEvaluator;

    GraceHashJoinOperatorNodePushable(IHyracksTaskContext ctx, Object state0Id, Object state1Id, int recordsPerFrame, double factor, int[] keys0, int[] keys1, IBinaryHashFunctionFactory[] hashFunctionFactories, IBinaryComparatorFactory[] comparatorFactories, INullWriterFactory[] nullWriterFactories, RecordDescriptor rd1, RecordDescriptor rd0, RecordDescriptor outRecordDescriptor, int numPartitions, IPredicateEvaluator predEval, boolean isLeftOuter) {
        this.ctx = ctx;
        this.state0Id = state0Id;
        this.state1Id = state1Id;
        this.keys0 = keys0;
        this.keys1 = keys1;
        this.hashFunctionFactories = hashFunctionFactories;
        this.comparatorFactories = comparatorFactories;
        this.nullWriterFactories = nullWriterFactories;
        this.rd0 = rd0;
        this.rd1 = rd1;
        this.numPartitions = numPartitions;
        this.recordsPerFrame = recordsPerFrame;
        this.factor = factor;
        this.predEvaluator = predEval;
        this.isLeftOuter = isLeftOuter;
    }

    @Override
    public void initialize() throws HyracksDataException {
        INullWriter[] nullWriters1;
        GraceHashJoinPartitionState rState = (GraceHashJoinPartitionState)this.ctx.getStateObject(this.state0Id);
        GraceHashJoinPartitionState sState = (GraceHashJoinPartitionState)this.ctx.getStateObject(this.state1Id);
        RunFileWriter[] buildWriters = sState.getRunWriters();
        RunFileWriter[] probeWriters = rState.getRunWriters();
        IBinaryComparator[] comparators = new IBinaryComparator[this.comparatorFactories.length];
        for (int i = 0; i < this.comparatorFactories.length; ++i) {
            comparators[i] = this.comparatorFactories[i].createBinaryComparator();
        }
        ITuplePartitionComputer hpcRep0 = new RepartitionComputerFactory(this.numPartitions, (ITuplePartitionComputerFactory)new FieldHashPartitionComputerFactory(this.keys0, this.hashFunctionFactories)).createPartitioner();
        ITuplePartitionComputer hpcRep1 = new RepartitionComputerFactory(this.numPartitions, (ITuplePartitionComputerFactory)new FieldHashPartitionComputerFactory(this.keys1, this.hashFunctionFactories)).createPartitioner();
        INullWriter[] iNullWriterArray = nullWriters1 = this.isLeftOuter ? new INullWriter[this.nullWriterFactories.length] : null;
        if (this.isLeftOuter) {
            for (int i = 0; i < this.nullWriterFactories.length; ++i) {
                nullWriters1[i] = this.nullWriterFactories[i].createNullWriter();
            }
        }
        this.writer.open();
        try {
            ByteBuffer buffer = this.ctx.allocateFrame();
            int tableSize = (int)((double)(this.numPartitions * this.recordsPerFrame) * this.factor);
            SerializableHashTable table = new SerializableHashTable(tableSize, this.ctx);
            for (int partitionid = 0; partitionid < this.numPartitions; ++partitionid) {
                RunFileWriter buildWriter = buildWriters[partitionid];
                RunFileWriter probeWriter = probeWriters[partitionid];
                if (buildWriter == null && !this.isLeftOuter || probeWriter == null) continue;
                table.reset();
                InMemoryHashJoin joiner = new InMemoryHashJoin(this.ctx, tableSize, new FrameTupleAccessor(this.ctx.getFrameSize(), this.rd0), hpcRep0, new FrameTupleAccessor(this.ctx.getFrameSize(), this.rd1), hpcRep1, new FrameTuplePairComparator(this.keys0, this.keys1, comparators), this.isLeftOuter, nullWriters1, table, this.predEvaluator);
                if (buildWriter != null) {
                    RunFileReader buildReader = buildWriter.createReader();
                    buildReader.open();
                    while (buildReader.nextFrame(buffer)) {
                        ByteBuffer copyBuffer = this.ctx.allocateFrame();
                        FrameUtils.copy((ByteBuffer)buffer, (ByteBuffer)copyBuffer);
                        joiner.build(copyBuffer);
                        buffer.clear();
                    }
                    buildReader.close();
                }
                RunFileReader probeReader = probeWriter.createReader();
                probeReader.open();
                while (probeReader.nextFrame(buffer)) {
                    joiner.join(buffer, this.writer);
                    buffer.clear();
                }
                probeReader.close();
                joiner.closeJoin(this.writer);
            }
        }
        catch (Exception e) {
            this.writer.fail();
            throw new HyracksDataException((Throwable)e);
        }
        finally {
            this.writer.close();
        }
    }
}

