/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.std.join;

import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.ActivityId;
import edu.uci.ics.hyracks.api.dataflow.IActivity;
import edu.uci.ics.hyracks.api.dataflow.IActivityGraphBuilder;
import edu.uci.ics.hyracks.api.dataflow.IOperatorDescriptor;
import edu.uci.ics.hyracks.api.dataflow.IOperatorNodePushable;
import edu.uci.ics.hyracks.api.dataflow.TaskId;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryHashFunctionFactory;
import edu.uci.ics.hyracks.api.dataflow.value.INullWriterFactory;
import edu.uci.ics.hyracks.api.dataflow.value.IPredicateEvaluator;
import edu.uci.ics.hyracks.api.dataflow.value.IPredicateEvaluatorFactory;
import edu.uci.ics.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.job.IOperatorDescriptorRegistry;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractActivityNode;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractOperatorDescriptor;
import edu.uci.ics.hyracks.dataflow.std.join.GraceHashJoinOperatorNodePushable;
import edu.uci.ics.hyracks.dataflow.std.join.GraceHashJoinPartitionBuildOperatorNodePushable;

public class GraceHashJoinOperatorDescriptor
extends AbstractOperatorDescriptor {
    private static final int RPARTITION_ACTIVITY_ID = 0;
    private static final int SPARTITION_ACTIVITY_ID = 1;
    private static final int JOIN_ACTIVITY_ID = 2;
    private static final long serialVersionUID = 1L;
    private final int[] keys0;
    private final int[] keys1;
    private final int inputsize0;
    private final int recordsPerFrame;
    private final int memsize;
    private final double factor;
    private final IBinaryHashFunctionFactory[] hashFunctionFactories;
    private final IBinaryComparatorFactory[] comparatorFactories;
    private final IPredicateEvaluatorFactory predEvaluatorFactory;
    private final boolean isLeftOuter;
    private final INullWriterFactory[] nullWriterFactories1;

    public GraceHashJoinOperatorDescriptor(IOperatorDescriptorRegistry spec, int memsize, int inputsize0, int recordsPerFrame, double factor, int[] keys0, int[] keys1, IBinaryHashFunctionFactory[] hashFunctionFactories, IBinaryComparatorFactory[] comparatorFactories, RecordDescriptor recordDescriptor, IPredicateEvaluatorFactory predEvalFactory) {
        super(spec, 2, 1);
        this.memsize = memsize;
        this.inputsize0 = inputsize0;
        this.recordsPerFrame = recordsPerFrame;
        this.factor = factor;
        this.keys0 = keys0;
        this.keys1 = keys1;
        this.hashFunctionFactories = hashFunctionFactories;
        this.comparatorFactories = comparatorFactories;
        this.predEvaluatorFactory = predEvalFactory;
        this.isLeftOuter = false;
        this.nullWriterFactories1 = null;
        this.recordDescriptors[0] = recordDescriptor;
    }

    public GraceHashJoinOperatorDescriptor(IOperatorDescriptorRegistry spec, int memsize, int inputsize0, int recordsPerFrame, double factor, int[] keys0, int[] keys1, IBinaryHashFunctionFactory[] hashFunctionFactories, IBinaryComparatorFactory[] comparatorFactories, RecordDescriptor recordDescriptor, boolean isLeftOuter, INullWriterFactory[] nullWriterFactories1, IPredicateEvaluatorFactory predEvalFactory) {
        super(spec, 2, 1);
        this.memsize = memsize;
        this.inputsize0 = inputsize0;
        this.recordsPerFrame = recordsPerFrame;
        this.factor = factor;
        this.keys0 = keys0;
        this.keys1 = keys1;
        this.hashFunctionFactories = hashFunctionFactories;
        this.comparatorFactories = comparatorFactories;
        this.predEvaluatorFactory = predEvalFactory;
        this.isLeftOuter = isLeftOuter;
        this.nullWriterFactories1 = nullWriterFactories1;
        this.recordDescriptors[0] = recordDescriptor;
    }

    public void contributeActivities(IActivityGraphBuilder builder) {
        ActivityId rpartAid = new ActivityId(this.odId, 0);
        HashPartitionActivityNode rpart = new HashPartitionActivityNode(rpartAid, this.keys0);
        ActivityId spartAid = new ActivityId(this.odId, 1);
        HashPartitionActivityNode spart = new HashPartitionActivityNode(spartAid, this.keys1);
        JoinActivityNode join = new JoinActivityNode(new ActivityId(this.odId, 2), rpartAid, spartAid);
        builder.addActivity((IOperatorDescriptor)this, (IActivity)rpart);
        builder.addSourceEdge(0, (IActivity)rpart, 0);
        builder.addActivity((IOperatorDescriptor)this, (IActivity)spart);
        builder.addSourceEdge(1, (IActivity)spart, 0);
        builder.addActivity((IOperatorDescriptor)this, (IActivity)join);
        builder.addBlockingEdge((IActivity)rpart, (IActivity)spart);
        builder.addBlockingEdge((IActivity)spart, (IActivity)join);
        builder.addTargetEdge(0, (IActivity)join, 0);
    }

    public int getMemorySize() {
        return this.memsize;
    }

    private class JoinActivityNode
    extends AbstractActivityNode {
        private static final long serialVersionUID = 1L;
        private final ActivityId rpartAid;
        private final ActivityId spartAid;

        public JoinActivityNode(ActivityId id, ActivityId rpartAid, ActivityId spartAid) {
            super(id);
            this.rpartAid = rpartAid;
            this.spartAid = spartAid;
        }

        public IOperatorNodePushable createPushRuntime(IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, int partition, int nPartitions) {
            RecordDescriptor rd0 = recordDescProvider.getInputRecordDescriptor(this.rpartAid, 0);
            RecordDescriptor rd1 = recordDescProvider.getInputRecordDescriptor(this.spartAid, 0);
            int numPartitions = (int)Math.ceil(Math.sqrt((double)GraceHashJoinOperatorDescriptor.this.inputsize0 * GraceHashJoinOperatorDescriptor.this.factor / (double)nPartitions));
            IPredicateEvaluator predEvaluator = GraceHashJoinOperatorDescriptor.this.predEvaluatorFactory == null ? null : GraceHashJoinOperatorDescriptor.this.predEvaluatorFactory.createPredicateEvaluator();
            return new GraceHashJoinOperatorNodePushable(ctx, new TaskId(new ActivityId(GraceHashJoinOperatorDescriptor.this.getOperatorId(), 0), partition), new TaskId(new ActivityId(GraceHashJoinOperatorDescriptor.this.getOperatorId(), 1), partition), GraceHashJoinOperatorDescriptor.this.recordsPerFrame, GraceHashJoinOperatorDescriptor.this.factor, GraceHashJoinOperatorDescriptor.this.keys0, GraceHashJoinOperatorDescriptor.this.keys1, GraceHashJoinOperatorDescriptor.this.hashFunctionFactories, GraceHashJoinOperatorDescriptor.this.comparatorFactories, GraceHashJoinOperatorDescriptor.this.nullWriterFactories1, rd1, rd0, GraceHashJoinOperatorDescriptor.this.recordDescriptors[0], numPartitions, predEvaluator, GraceHashJoinOperatorDescriptor.this.isLeftOuter);
        }
    }

    private class HashPartitionActivityNode
    extends AbstractActivityNode {
        private static final long serialVersionUID = 1L;
        private int[] keys;

        public HashPartitionActivityNode(ActivityId id, int[] keys) {
            super(id);
            this.keys = keys;
        }

        public IOperatorNodePushable createPushRuntime(IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, int partition, int nPartitions) {
            return new GraceHashJoinPartitionBuildOperatorNodePushable(ctx, new TaskId(this.getActivityId(), partition), this.keys, GraceHashJoinOperatorDescriptor.this.hashFunctionFactories, GraceHashJoinOperatorDescriptor.this.comparatorFactories, (int)Math.ceil(Math.sqrt((double)GraceHashJoinOperatorDescriptor.this.inputsize0 * GraceHashJoinOperatorDescriptor.this.factor / (double)nPartitions)), recordDescProvider.getInputRecordDescriptor(this.getActivityId(), 0));
        }
    }
}

