/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.std.group.preclustered;

import edu.uci.ics.hyracks.api.comm.IFrameTupleAccessor;
import edu.uci.ics.hyracks.api.comm.IFrameWriter;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryComparator;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import edu.uci.ics.hyracks.dataflow.common.comm.util.FrameUtils;
import edu.uci.ics.hyracks.dataflow.std.group.AggregateState;
import edu.uci.ics.hyracks.dataflow.std.group.IAggregatorDescriptor;
import java.nio.ByteBuffer;

public class PreclusteredGroupWriter
implements IFrameWriter {
    private final int[] groupFields;
    private final IBinaryComparator[] comparators;
    private final IAggregatorDescriptor aggregator;
    private final AggregateState aggregateState;
    private final IFrameWriter writer;
    private final ByteBuffer copyFrame;
    private final FrameTupleAccessor inFrameAccessor;
    private final FrameTupleAccessor copyFrameAccessor;
    private final ByteBuffer outFrame;
    private final FrameTupleAppender appender;
    private final ArrayTupleBuilder tupleBuilder;
    private boolean first;
    private boolean isFailed = false;

    public PreclusteredGroupWriter(IHyracksTaskContext ctx, int[] groupFields, IBinaryComparator[] comparators, IAggregatorDescriptor aggregator, RecordDescriptor inRecordDesc, RecordDescriptor outRecordDesc, IFrameWriter writer) throws HyracksDataException {
        this.groupFields = groupFields;
        this.comparators = comparators;
        this.aggregator = aggregator;
        this.aggregateState = aggregator.createAggregateStates();
        this.writer = writer;
        this.copyFrame = ctx.allocateFrame();
        this.inFrameAccessor = new FrameTupleAccessor(ctx.getFrameSize(), inRecordDesc);
        this.copyFrameAccessor = new FrameTupleAccessor(ctx.getFrameSize(), inRecordDesc);
        this.copyFrameAccessor.reset(this.copyFrame);
        this.outFrame = ctx.allocateFrame();
        this.appender = new FrameTupleAppender(ctx.getFrameSize());
        this.appender.reset(this.outFrame, true);
        this.tupleBuilder = new ArrayTupleBuilder(outRecordDesc.getFields().length);
    }

    public void open() throws HyracksDataException {
        this.writer.open();
        this.first = true;
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.inFrameAccessor.reset(buffer);
        int nTuples = this.inFrameAccessor.getTupleCount();
        for (int i = 0; i < nTuples; ++i) {
            if (this.first) {
                this.tupleBuilder.reset();
                for (int j = 0; j < this.groupFields.length; ++j) {
                    this.tupleBuilder.addField((IFrameTupleAccessor)this.inFrameAccessor, i, this.groupFields[j]);
                }
                this.aggregator.init(this.tupleBuilder, (IFrameTupleAccessor)this.inFrameAccessor, i, this.aggregateState);
                this.first = false;
                continue;
            }
            if (i == 0) {
                this.switchGroupIfRequired(this.copyFrameAccessor, this.copyFrameAccessor.getTupleCount() - 1, this.inFrameAccessor, i);
                continue;
            }
            this.switchGroupIfRequired(this.inFrameAccessor, i - 1, this.inFrameAccessor, i);
        }
        FrameUtils.copy((ByteBuffer)buffer, (ByteBuffer)this.copyFrame);
    }

    private void switchGroupIfRequired(FrameTupleAccessor prevTupleAccessor, int prevTupleIndex, FrameTupleAccessor currTupleAccessor, int currTupleIndex) throws HyracksDataException {
        if (!this.sameGroup(prevTupleAccessor, prevTupleIndex, currTupleAccessor, currTupleIndex)) {
            this.writeOutput(prevTupleAccessor, prevTupleIndex);
            this.tupleBuilder.reset();
            for (int j = 0; j < this.groupFields.length; ++j) {
                this.tupleBuilder.addField((IFrameTupleAccessor)currTupleAccessor, currTupleIndex, this.groupFields[j]);
            }
            this.aggregator.init(this.tupleBuilder, (IFrameTupleAccessor)currTupleAccessor, currTupleIndex, this.aggregateState);
        } else {
            this.aggregator.aggregate((IFrameTupleAccessor)currTupleAccessor, currTupleIndex, null, 0, this.aggregateState);
        }
    }

    private void writeOutput(FrameTupleAccessor lastTupleAccessor, int lastTupleIndex) throws HyracksDataException {
        this.tupleBuilder.reset();
        for (int j = 0; j < this.groupFields.length; ++j) {
            this.tupleBuilder.addField((IFrameTupleAccessor)lastTupleAccessor, lastTupleIndex, this.groupFields[j]);
        }
        boolean hasOutput = this.aggregator.outputFinalResult(this.tupleBuilder, (IFrameTupleAccessor)lastTupleAccessor, lastTupleIndex, this.aggregateState);
        if (hasOutput && !this.appender.appendSkipEmptyField(this.tupleBuilder.getFieldEndOffsets(), this.tupleBuilder.getByteArray(), 0, this.tupleBuilder.getSize())) {
            FrameUtils.flushFrame((ByteBuffer)this.outFrame, (IFrameWriter)this.writer);
            this.appender.reset(this.outFrame, true);
            if (!this.appender.appendSkipEmptyField(this.tupleBuilder.getFieldEndOffsets(), this.tupleBuilder.getByteArray(), 0, this.tupleBuilder.getSize())) {
                throw new HyracksDataException("The output cannot be fit into a frame.");
            }
        }
    }

    private boolean sameGroup(FrameTupleAccessor a1, int t1Idx, FrameTupleAccessor a2, int t2Idx) {
        for (int i = 0; i < this.comparators.length; ++i) {
            int fIdx = this.groupFields[i];
            int s1 = a1.getTupleStartOffset(t1Idx) + a1.getFieldSlotsLength() + a1.getFieldStartOffset(t1Idx, fIdx);
            int l1 = a1.getFieldLength(t1Idx, fIdx);
            int s2 = a2.getTupleStartOffset(t2Idx) + a2.getFieldSlotsLength() + a2.getFieldStartOffset(t2Idx, fIdx);
            int l2 = a2.getFieldLength(t2Idx, fIdx);
            if (this.comparators[i].compare(a1.getBuffer().array(), s1, l1, a2.getBuffer().array(), s2, l2) == 0) continue;
            return false;
        }
        return true;
    }

    public void fail() throws HyracksDataException {
        this.isFailed = true;
        this.writer.fail();
    }

    public void close() throws HyracksDataException {
        if (!this.isFailed && !this.first) {
            this.writeOutput(this.copyFrameAccessor, this.copyFrameAccessor.getTupleCount() - 1);
            if (this.appender.getTupleCount() > 0) {
                FrameUtils.flushFrame((ByteBuffer)this.outFrame, (IFrameWriter)this.writer);
            }
        }
        this.aggregator.close();
        this.aggregateState.close();
        this.writer.close();
    }
}

