/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.std.group.preclustered;

import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryComparator;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractUnaryInputUnaryOutputOperatorNodePushable;
import edu.uci.ics.hyracks.dataflow.std.group.IAggregatorDescriptor;
import edu.uci.ics.hyracks.dataflow.std.group.IAggregatorDescriptorFactory;
import edu.uci.ics.hyracks.dataflow.std.group.preclustered.PreclusteredGroupWriter;
import java.nio.ByteBuffer;

class PreclusteredGroupOperatorNodePushable
extends AbstractUnaryInputUnaryOutputOperatorNodePushable {
    private final IHyracksTaskContext ctx;
    private final int[] groupFields;
    private final IBinaryComparatorFactory[] comparatorFactories;
    private final IAggregatorDescriptorFactory aggregatorFactory;
    private final RecordDescriptor inRecordDescriptor;
    private final RecordDescriptor outRecordDescriptor;
    private PreclusteredGroupWriter pgw;

    PreclusteredGroupOperatorNodePushable(IHyracksTaskContext ctx, int[] groupFields, IBinaryComparatorFactory[] comparatorFactories, IAggregatorDescriptorFactory aggregatorFactory, RecordDescriptor inRecordDescriptor, RecordDescriptor outRecordDescriptor) {
        this.ctx = ctx;
        this.groupFields = groupFields;
        this.comparatorFactories = comparatorFactories;
        this.aggregatorFactory = aggregatorFactory;
        this.inRecordDescriptor = inRecordDescriptor;
        this.outRecordDescriptor = outRecordDescriptor;
    }

    public void open() throws HyracksDataException {
        IBinaryComparator[] comparators = new IBinaryComparator[this.comparatorFactories.length];
        for (int i = 0; i < this.comparatorFactories.length; ++i) {
            comparators[i] = this.comparatorFactories[i].createBinaryComparator();
        }
        IAggregatorDescriptor aggregator = this.aggregatorFactory.createAggregator(this.ctx, this.inRecordDescriptor, this.outRecordDescriptor, this.groupFields, this.groupFields, this.writer);
        ByteBuffer copyFrame = this.ctx.allocateFrame();
        FrameTupleAccessor copyFrameAccessor = new FrameTupleAccessor(this.ctx.getFrameSize(), this.inRecordDescriptor);
        copyFrameAccessor.reset(copyFrame);
        ByteBuffer outFrame = this.ctx.allocateFrame();
        FrameTupleAppender appender = new FrameTupleAppender(this.ctx.getFrameSize());
        appender.reset(outFrame, true);
        this.pgw = new PreclusteredGroupWriter(this.ctx, this.groupFields, comparators, aggregator, this.inRecordDescriptor, this.outRecordDescriptor, this.writer);
        this.pgw.open();
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.pgw.nextFrame(buffer);
    }

    public void fail() throws HyracksDataException {
        this.pgw.fail();
    }

    public void close() throws HyracksDataException {
        this.pgw.close();
    }
}

