/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.std.group.hash;

import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.ActivityId;
import edu.uci.ics.hyracks.api.dataflow.IActivity;
import edu.uci.ics.hyracks.api.dataflow.IActivityGraphBuilder;
import edu.uci.ics.hyracks.api.dataflow.IOperatorDescriptor;
import edu.uci.ics.hyracks.api.dataflow.IOperatorNodePushable;
import edu.uci.ics.hyracks.api.dataflow.TaskId;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import edu.uci.ics.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import edu.uci.ics.hyracks.api.dataflow.value.ITuplePartitionComputerFactory;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.job.IOperatorDescriptorRegistry;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractActivityNode;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractOperatorDescriptor;
import edu.uci.ics.hyracks.dataflow.std.group.IAggregatorDescriptorFactory;
import edu.uci.ics.hyracks.dataflow.std.group.hash.HashGroupBuildOperatorNodePushable;
import edu.uci.ics.hyracks.dataflow.std.group.hash.HashGroupOutputOperatorNodePushable;

public class HashGroupOperatorDescriptor
extends AbstractOperatorDescriptor {
    private static final int HASH_BUILD_ACTIVITY_ID = 0;
    private static final int OUTPUT_ACTIVITY_ID = 1;
    private static final long serialVersionUID = 1L;
    private final int[] keys;
    private final ITuplePartitionComputerFactory tpcf;
    private final IBinaryComparatorFactory[] comparatorFactories;
    private final IAggregatorDescriptorFactory aggregatorFactory;
    private final int tableSize;

    public HashGroupOperatorDescriptor(IOperatorDescriptorRegistry spec, int[] keys, ITuplePartitionComputerFactory tpcf, IBinaryComparatorFactory[] comparatorFactories, IAggregatorDescriptorFactory aggregatorFactory, RecordDescriptor outRecordDescriptor, int tableSize) {
        super(spec, 1, 1);
        this.keys = keys;
        this.tpcf = tpcf;
        this.comparatorFactories = comparatorFactories;
        this.aggregatorFactory = aggregatorFactory;
        this.recordDescriptors[0] = outRecordDescriptor;
        this.tableSize = tableSize;
    }

    public void contributeActivities(IActivityGraphBuilder builder) {
        HashBuildActivity ha = new HashBuildActivity(new ActivityId(this.odId, 0));
        builder.addActivity((IOperatorDescriptor)this, (IActivity)ha);
        OutputActivity oa = new OutputActivity(new ActivityId(this.odId, 1));
        builder.addActivity((IOperatorDescriptor)this, (IActivity)oa);
        builder.addSourceEdge(0, (IActivity)ha, 0);
        builder.addTargetEdge(0, (IActivity)oa, 0);
        builder.addBlockingEdge((IActivity)ha, (IActivity)oa);
    }

    private class OutputActivity
    extends AbstractActivityNode {
        private static final long serialVersionUID = 1L;

        public OutputActivity(ActivityId id) {
            super(id);
        }

        public IOperatorNodePushable createPushRuntime(IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, int partition, int nPartitions) {
            return new HashGroupOutputOperatorNodePushable(ctx, new TaskId(new ActivityId(HashGroupOperatorDescriptor.this.getOperatorId(), 0), partition));
        }
    }

    private class HashBuildActivity
    extends AbstractActivityNode {
        private static final long serialVersionUID = 1L;

        public HashBuildActivity(ActivityId id) {
            super(id);
        }

        public IOperatorNodePushable createPushRuntime(IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, int partition, int nPartitions) {
            return new HashGroupBuildOperatorNodePushable(ctx, new TaskId(this.getActivityId(), partition), HashGroupOperatorDescriptor.this.keys, HashGroupOperatorDescriptor.this.tpcf, HashGroupOperatorDescriptor.this.comparatorFactories, HashGroupOperatorDescriptor.this.aggregatorFactory, HashGroupOperatorDescriptor.this.tableSize, recordDescProvider.getInputRecordDescriptor(this.getActivityId(), 0), HashGroupOperatorDescriptor.this.recordDescriptors[0]);
        }
    }
}

