/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.std.group.hash;

import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.state.IStateObject;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import edu.uci.ics.hyracks.api.dataflow.value.ITuplePartitionComputerFactory;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractUnaryInputSinkOperatorNodePushable;
import edu.uci.ics.hyracks.dataflow.std.group.IAggregatorDescriptorFactory;
import edu.uci.ics.hyracks.dataflow.std.group.hash.GroupingHashTable;
import edu.uci.ics.hyracks.dataflow.std.group.hash.HashGroupState;
import java.nio.ByteBuffer;

class HashGroupBuildOperatorNodePushable
extends AbstractUnaryInputSinkOperatorNodePushable {
    private final IHyracksTaskContext ctx;
    private final FrameTupleAccessor accessor;
    private final Object stateId;
    private final int[] keys;
    private final ITuplePartitionComputerFactory tpcf;
    private final IBinaryComparatorFactory[] comparatorFactories;
    private final IAggregatorDescriptorFactory aggregatorFactory;
    private final int tableSize;
    private final RecordDescriptor inRecordDescriptor;
    private final RecordDescriptor outRecordDescriptor;
    private HashGroupState state;

    HashGroupBuildOperatorNodePushable(IHyracksTaskContext ctx, Object stateId, int[] keys, ITuplePartitionComputerFactory tpcf, IBinaryComparatorFactory[] comparatorFactories, IAggregatorDescriptorFactory aggregatorFactory, int tableSize, RecordDescriptor inRecordDescriptor, RecordDescriptor outRecordDescriptor) {
        this.ctx = ctx;
        this.accessor = new FrameTupleAccessor(ctx.getFrameSize(), inRecordDescriptor);
        this.stateId = stateId;
        this.keys = keys;
        this.tpcf = tpcf;
        this.comparatorFactories = comparatorFactories;
        this.aggregatorFactory = aggregatorFactory;
        this.tableSize = tableSize;
        this.inRecordDescriptor = inRecordDescriptor;
        this.outRecordDescriptor = outRecordDescriptor;
    }

    public void open() throws HyracksDataException {
        this.state = new HashGroupState(this.ctx.getJobletContext().getJobId(), this.stateId);
        this.state.setHashTable(new GroupingHashTable(this.ctx, this.keys, this.comparatorFactories, this.tpcf, this.aggregatorFactory, this.inRecordDescriptor, this.outRecordDescriptor, this.tableSize));
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        GroupingHashTable table = this.state.getHashTable();
        this.accessor.reset(buffer);
        int tupleCount = this.accessor.getTupleCount();
        for (int i = 0; i < tupleCount; ++i) {
            try {
                table.insert(this.accessor, i);
                continue;
            }
            catch (Exception e) {
                System.out.println(e.toString());
                throw new HyracksDataException((Throwable)e);
            }
        }
    }

    public void close() throws HyracksDataException {
        this.ctx.setStateObject((IStateObject)this.state);
    }

    public void fail() throws HyracksDataException {
        throw new HyracksDataException("HashGroupOperator is failed.");
    }
}

