/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.std.group.hash;

import edu.uci.ics.hyracks.api.comm.IFrameTupleAccessor;
import edu.uci.ics.hyracks.api.comm.IFrameWriter;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryComparator;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import edu.uci.ics.hyracks.api.dataflow.value.ISerializerDeserializer;
import edu.uci.ics.hyracks.api.dataflow.value.ITuplePartitionComputer;
import edu.uci.ics.hyracks.api.dataflow.value.ITuplePartitionComputerFactory;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTuplePairComparator;
import edu.uci.ics.hyracks.dataflow.std.group.AggregateState;
import edu.uci.ics.hyracks.dataflow.std.group.IAggregatorDescriptor;
import edu.uci.ics.hyracks.dataflow.std.group.IAggregatorDescriptorFactory;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class GroupingHashTable {
    private static final int INIT_AGG_STATE_SIZE = 8;
    private final IHyracksTaskContext ctx;
    private final List<ByteBuffer> buffers;
    private final Link[] table;
    private AggregateState[] aggregateStates;
    private int accumulatorSize;
    private int lastBIndex;
    private final int[] storedKeys;
    private final int[] keys;
    private final IBinaryComparator[] comparators;
    private final FrameTuplePairComparator ftpc;
    private final ITuplePartitionComputer tpc;
    private final IAggregatorDescriptor aggregator;
    private final FrameTupleAppender appender;
    private final FrameTupleAccessor storedKeysAccessor;
    private final ArrayTupleBuilder stateTupleBuilder;
    private final ArrayTupleBuilder outputTupleBuilder;

    GroupingHashTable(IHyracksTaskContext ctx, int[] fields, IBinaryComparatorFactory[] comparatorFactories, ITuplePartitionComputerFactory tpcf, IAggregatorDescriptorFactory aggregatorFactory, RecordDescriptor inRecordDescriptor, RecordDescriptor outRecordDescriptor, int tableSize) throws HyracksDataException {
        int i;
        this.ctx = ctx;
        this.buffers = new ArrayList<ByteBuffer>();
        this.table = new Link[tableSize];
        this.keys = fields;
        this.storedKeys = new int[fields.length];
        ISerializerDeserializer[] storedKeySerDeser = new ISerializerDeserializer[fields.length];
        for (i = 0; i < fields.length; ++i) {
            this.storedKeys[i] = i;
            storedKeySerDeser[i] = inRecordDescriptor.getFields()[fields[i]];
        }
        this.comparators = new IBinaryComparator[comparatorFactories.length];
        for (i = 0; i < comparatorFactories.length; ++i) {
            this.comparators[i] = comparatorFactories[i].createBinaryComparator();
        }
        this.ftpc = new FrameTuplePairComparator(fields, this.storedKeys, this.comparators);
        this.tpc = tpcf.createPartitioner();
        int[] keyFieldsInPartialResults = new int[fields.length];
        for (int i2 = 0; i2 < keyFieldsInPartialResults.length; ++i2) {
            keyFieldsInPartialResults[i2] = i2;
        }
        this.aggregator = aggregatorFactory.createAggregator(ctx, inRecordDescriptor, outRecordDescriptor, fields, keyFieldsInPartialResults, null);
        this.aggregateStates = new AggregateState[8];
        this.accumulatorSize = 0;
        RecordDescriptor storedKeysRecordDescriptor = new RecordDescriptor(storedKeySerDeser);
        this.storedKeysAccessor = new FrameTupleAccessor(ctx.getFrameSize(), storedKeysRecordDescriptor);
        this.lastBIndex = -1;
        this.appender = new FrameTupleAppender(ctx.getFrameSize());
        this.addNewBuffer();
        this.stateTupleBuilder = fields.length < outRecordDescriptor.getFields().length ? new ArrayTupleBuilder(outRecordDescriptor.getFields().length) : new ArrayTupleBuilder(outRecordDescriptor.getFields().length + 1);
        this.outputTupleBuilder = new ArrayTupleBuilder(outRecordDescriptor.getFields().length);
    }

    private void addNewBuffer() throws HyracksDataException {
        ByteBuffer buffer = this.ctx.allocateFrame();
        buffer.position(0);
        buffer.limit(buffer.capacity());
        this.buffers.add(buffer);
        this.appender.reset(buffer, true);
        ++this.lastBIndex;
    }

    void insert(FrameTupleAccessor accessor, int tIndex) throws Exception {
        int entry = this.tpc.partition((IFrameTupleAccessor)accessor, tIndex, this.table.length);
        Link link = this.table[entry];
        if (link == null) {
            link = this.table[entry] = new Link();
        }
        int saIndex = -1;
        for (int i = 0; i < link.size; i += 3) {
            int sbIndex = link.pointers[i];
            int stIndex = link.pointers[i + 1];
            this.storedKeysAccessor.reset(this.buffers.get(sbIndex));
            int c = this.ftpc.compare(accessor, tIndex, this.storedKeysAccessor, stIndex);
            if (c != 0) continue;
            saIndex = link.pointers[i + 2];
            break;
        }
        if (saIndex < 0) {
            saIndex = this.accumulatorSize++;
            AggregateState newState = this.aggregator.createAggregateStates();
            this.stateTupleBuilder.reset();
            for (int k = 0; k < this.keys.length; ++k) {
                this.stateTupleBuilder.addField((IFrameTupleAccessor)accessor, tIndex, this.keys[k]);
            }
            this.aggregator.init(this.stateTupleBuilder, (IFrameTupleAccessor)accessor, tIndex, newState);
            if (!this.appender.appendSkipEmptyField(this.stateTupleBuilder.getFieldEndOffsets(), this.stateTupleBuilder.getByteArray(), 0, this.stateTupleBuilder.getSize())) {
                this.addNewBuffer();
                if (!this.appender.appendSkipEmptyField(this.stateTupleBuilder.getFieldEndOffsets(), this.stateTupleBuilder.getByteArray(), 0, this.stateTupleBuilder.getSize())) {
                    throw new HyracksDataException("Cannot init the aggregate state in a single frame.");
                }
            }
            if (this.accumulatorSize >= this.aggregateStates.length) {
                this.aggregateStates = Arrays.copyOf(this.aggregateStates, this.aggregateStates.length * 2);
            }
            this.aggregateStates[saIndex] = newState;
            link.add(this.lastBIndex, this.appender.getTupleCount() - 1, saIndex);
        } else {
            this.aggregator.aggregate((IFrameTupleAccessor)accessor, tIndex, null, 0, this.aggregateStates[saIndex]);
        }
    }

    void write(IFrameWriter writer) throws HyracksDataException {
        ByteBuffer buffer = this.ctx.allocateFrame();
        this.appender.reset(buffer, true);
        for (int i = 0; i < this.table.length; ++i) {
            Link link = this.table[i];
            if (link == null) continue;
            for (int j = 0; j < link.size; j += 3) {
                int bIndex = link.pointers[j];
                int tIndex = link.pointers[j + 1];
                int aIndex = link.pointers[j + 2];
                ByteBuffer keyBuffer = this.buffers.get(bIndex);
                this.storedKeysAccessor.reset(keyBuffer);
                this.outputTupleBuilder.reset();
                for (int k = 0; k < this.storedKeys.length; ++k) {
                    this.outputTupleBuilder.addField((IFrameTupleAccessor)this.storedKeysAccessor, tIndex, this.storedKeys[k]);
                }
                this.aggregator.outputFinalResult(this.outputTupleBuilder, (IFrameTupleAccessor)this.storedKeysAccessor, tIndex, this.aggregateStates[aIndex]);
                if (this.appender.appendSkipEmptyField(this.outputTupleBuilder.getFieldEndOffsets(), this.outputTupleBuilder.getByteArray(), 0, this.outputTupleBuilder.getSize())) continue;
                writer.nextFrame(buffer);
                this.appender.reset(buffer, true);
                if (this.appender.appendSkipEmptyField(this.outputTupleBuilder.getFieldEndOffsets(), this.outputTupleBuilder.getByteArray(), 0, this.outputTupleBuilder.getSize())) continue;
                throw new HyracksDataException("Cannot write the aggregation output into a frame.");
            }
        }
        if (this.appender.getTupleCount() != 0) {
            writer.nextFrame(buffer);
        }
    }

    void close() throws HyracksDataException {
        for (AggregateState aState : this.aggregateStates) {
            aState.close();
        }
    }

    private static class Link {
        private static final int INIT_POINTERS_SIZE = 9;
        int[] pointers = new int[9];
        int size = 0;

        Link() {
        }

        void add(int bufferIdx, int tIndex, int accumulatorIdx) {
            while (this.size + 3 > this.pointers.length) {
                this.pointers = Arrays.copyOf(this.pointers, this.pointers.length * 2);
            }
            this.pointers[this.size++] = bufferIdx;
            this.pointers[this.size++] = tIndex;
            this.pointers[this.size++] = accumulatorIdx;
        }
    }
}

