/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.std.group.external;

import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.ActivityId;
import edu.uci.ics.hyracks.api.dataflow.IActivity;
import edu.uci.ics.hyracks.api.dataflow.IActivityGraphBuilder;
import edu.uci.ics.hyracks.api.dataflow.IOperatorDescriptor;
import edu.uci.ics.hyracks.api.dataflow.IOperatorNodePushable;
import edu.uci.ics.hyracks.api.dataflow.TaskId;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import edu.uci.ics.hyracks.api.dataflow.value.INormalizedKeyComputerFactory;
import edu.uci.ics.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.api.job.IOperatorDescriptorRegistry;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractActivityNode;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractOperatorDescriptor;
import edu.uci.ics.hyracks.dataflow.std.group.IAggregatorDescriptorFactory;
import edu.uci.ics.hyracks.dataflow.std.group.ISpillableTableFactory;
import edu.uci.ics.hyracks.dataflow.std.group.external.ExternalGroupBuildOperatorNodePushable;
import edu.uci.ics.hyracks.dataflow.std.group.external.ExternalGroupMergeOperatorNodePushable;

public class ExternalGroupOperatorDescriptor
extends AbstractOperatorDescriptor {
    private static final int AGGREGATE_ACTIVITY_ID = 0;
    private static final int MERGE_ACTIVITY_ID = 1;
    private static final long serialVersionUID = 1L;
    private final int[] keyFields;
    private final IBinaryComparatorFactory[] comparatorFactories;
    private final INormalizedKeyComputerFactory firstNormalizerFactory;
    private final IAggregatorDescriptorFactory aggregatorFactory;
    private final IAggregatorDescriptorFactory mergerFactory;
    private final int framesLimit;
    private final ISpillableTableFactory spillableTableFactory;
    private final boolean isOutputSorted;

    public ExternalGroupOperatorDescriptor(IOperatorDescriptorRegistry spec, int[] keyFields, int framesLimit, IBinaryComparatorFactory[] comparatorFactories, INormalizedKeyComputerFactory firstNormalizerFactory, IAggregatorDescriptorFactory aggregatorFactory, IAggregatorDescriptorFactory mergerFactory, RecordDescriptor recordDescriptor, ISpillableTableFactory spillableTableFactory, boolean isOutputSorted) {
        super(spec, 1, 1);
        this.framesLimit = framesLimit;
        if (framesLimit <= 1) {
            throw new IllegalStateException("frame limit should at least be 2, but it is " + framesLimit + "!");
        }
        this.aggregatorFactory = aggregatorFactory;
        this.mergerFactory = mergerFactory;
        this.keyFields = keyFields;
        this.comparatorFactories = comparatorFactories;
        this.firstNormalizerFactory = firstNormalizerFactory;
        this.spillableTableFactory = spillableTableFactory;
        this.isOutputSorted = isOutputSorted;
        this.recordDescriptors[0] = recordDescriptor;
    }

    public void contributeActivities(IActivityGraphBuilder builder) {
        AggregateActivity aggregateAct = new AggregateActivity(new ActivityId(this.getOperatorId(), 0));
        MergeActivity mergeAct = new MergeActivity(new ActivityId(this.odId, 1));
        builder.addActivity((IOperatorDescriptor)this, (IActivity)aggregateAct);
        builder.addSourceEdge(0, (IActivity)aggregateAct, 0);
        builder.addActivity((IOperatorDescriptor)this, (IActivity)mergeAct);
        builder.addTargetEdge(0, (IActivity)mergeAct, 0);
        builder.addBlockingEdge((IActivity)aggregateAct, (IActivity)mergeAct);
    }

    private class MergeActivity
    extends AbstractActivityNode {
        private static final long serialVersionUID = 1L;

        public MergeActivity(ActivityId id) {
            super(id);
        }

        public IOperatorNodePushable createPushRuntime(IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, int partition, int nPartitions) throws HyracksDataException {
            return new ExternalGroupMergeOperatorNodePushable(ctx, new TaskId(new ActivityId(ExternalGroupOperatorDescriptor.this.getOperatorId(), 0), partition), ExternalGroupOperatorDescriptor.this.comparatorFactories, ExternalGroupOperatorDescriptor.this.firstNormalizerFactory, ExternalGroupOperatorDescriptor.this.keyFields, ExternalGroupOperatorDescriptor.this.mergerFactory, ExternalGroupOperatorDescriptor.this.isOutputSorted, ExternalGroupOperatorDescriptor.this.framesLimit, ExternalGroupOperatorDescriptor.this.recordDescriptors[0]);
        }
    }

    private class AggregateActivity
    extends AbstractActivityNode {
        private static final long serialVersionUID = 1L;

        public AggregateActivity(ActivityId id) {
            super(id);
        }

        public IOperatorNodePushable createPushRuntime(IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, int partition, int nPartitions) throws HyracksDataException {
            return new ExternalGroupBuildOperatorNodePushable(ctx, new TaskId(this.getActivityId(), partition), ExternalGroupOperatorDescriptor.this.keyFields, ExternalGroupOperatorDescriptor.this.framesLimit, ExternalGroupOperatorDescriptor.this.comparatorFactories, ExternalGroupOperatorDescriptor.this.firstNormalizerFactory, ExternalGroupOperatorDescriptor.this.aggregatorFactory, recordDescProvider.getInputRecordDescriptor(this.getActivityId(), 0), ExternalGroupOperatorDescriptor.this.recordDescriptors[0], ExternalGroupOperatorDescriptor.this.spillableTableFactory);
        }
    }
}

