/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.std.group.external;

import edu.uci.ics.hyracks.api.comm.IFrameTupleAccessor;
import edu.uci.ics.hyracks.api.comm.IFrameWriter;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryComparator;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import edu.uci.ics.hyracks.api.dataflow.value.INormalizedKeyComputer;
import edu.uci.ics.hyracks.api.dataflow.value.INormalizedKeyComputerFactory;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.api.io.FileReference;
import edu.uci.ics.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import edu.uci.ics.hyracks.dataflow.common.comm.util.FrameUtils;
import edu.uci.ics.hyracks.dataflow.common.io.RunFileReader;
import edu.uci.ics.hyracks.dataflow.common.io.RunFileWriter;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractUnaryOutputSourceOperatorNodePushable;
import edu.uci.ics.hyracks.dataflow.std.group.AggregateState;
import edu.uci.ics.hyracks.dataflow.std.group.IAggregatorDescriptor;
import edu.uci.ics.hyracks.dataflow.std.group.IAggregatorDescriptorFactory;
import edu.uci.ics.hyracks.dataflow.std.group.ISpillableTable;
import edu.uci.ics.hyracks.dataflow.std.group.external.ExternalGroupOperatorDescriptor;
import edu.uci.ics.hyracks.dataflow.std.group.external.ExternalGroupState;
import edu.uci.ics.hyracks.dataflow.std.util.ReferenceEntry;
import edu.uci.ics.hyracks.dataflow.std.util.ReferencedPriorityQueue;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

class ExternalGroupMergeOperatorNodePushable
extends AbstractUnaryOutputSourceOperatorNodePushable {
    private final IHyracksTaskContext ctx;
    private final Object stateId;
    private final int[] keyFields;
    private final IBinaryComparator[] comparators;
    private final INormalizedKeyComputer nmkComputer;
    private final AggregateState aggregateState;
    private final ArrayTupleBuilder tupleBuilder;
    private final int[] storedKeys;
    private final IAggregatorDescriptor aggregator;
    private final boolean isOutputSorted;
    private final int framesLimit;
    private final RecordDescriptor outRecordDescriptor;
    private List<ByteBuffer> inFrames;
    private ByteBuffer outFrame;
    private ByteBuffer writerFrame;
    private final FrameTupleAppender outAppender;
    private FrameTupleAppender writerAppender;
    private LinkedList<RunFileReader> runs;
    private ExternalGroupState aggState;
    private ArrayTupleBuilder finalTupleBuilder;
    private int runFrameLimit = 1;
    private int[] currentFrameIndexInRun;
    private int[] currentRunFrames;
    private final FrameTupleAccessor outFrameAccessor;

    ExternalGroupMergeOperatorNodePushable(IHyracksTaskContext ctx, Object stateId, IBinaryComparatorFactory[] comparatorFactories, INormalizedKeyComputerFactory nmkFactory, int[] keyFields, IAggregatorDescriptorFactory mergerFactory, boolean isOutputSorted, int framesLimit, RecordDescriptor outRecordDescriptor) throws HyracksDataException {
        int i;
        this.stateId = stateId;
        this.keyFields = keyFields;
        this.comparators = new IBinaryComparator[comparatorFactories.length];
        for (int i2 = 0; i2 < comparatorFactories.length; ++i2) {
            this.comparators[i2] = comparatorFactories[i2].createBinaryComparator();
        }
        this.nmkComputer = nmkFactory == null ? null : nmkFactory.createNormalizedKeyComputer();
        int[] keyFieldsInPartialResults = new int[keyFields.length];
        for (i = 0; i < keyFieldsInPartialResults.length; ++i) {
            keyFieldsInPartialResults[i] = i;
        }
        this.aggregator = mergerFactory.createAggregator(ctx, outRecordDescriptor, outRecordDescriptor, keyFields, keyFieldsInPartialResults, this.writer);
        this.aggregateState = this.aggregator.createAggregateStates();
        this.storedKeys = new int[keyFields.length];
        for (i = 0; i < keyFields.length; ++i) {
            this.storedKeys[i] = i;
        }
        this.tupleBuilder = new ArrayTupleBuilder(outRecordDescriptor.getFields().length);
        this.ctx = ctx;
        this.outAppender = new FrameTupleAppender(ctx.getFrameSize());
        this.outFrameAccessor = new FrameTupleAccessor(ctx.getFrameSize(), outRecordDescriptor);
        this.isOutputSorted = isOutputSorted;
        this.framesLimit = framesLimit;
        this.outRecordDescriptor = outRecordDescriptor;
    }

    @Override
    public void initialize() throws HyracksDataException {
        this.aggState = (ExternalGroupState)this.ctx.getStateObject(this.stateId);
        this.runs = this.aggState.getRuns();
        this.writer.open();
        try {
            if (this.runs.size() <= 0) {
                ISpillableTable gTable = this.aggState.getSpillableTable();
                if (gTable != null) {
                    if (this.isOutputSorted) {
                        gTable.sortFrames();
                    }
                    gTable.flushFrames(this.writer, false);
                }
                gTable = null;
                this.aggState = null;
            } else {
                this.aggState = null;
                this.runs = new LinkedList<RunFileReader>(this.runs);
                this.inFrames = new ArrayList<ByteBuffer>();
                this.outFrame = this.ctx.allocateFrame();
                this.outAppender.reset(this.outFrame, true);
                this.outFrameAccessor.reset(this.outFrame);
                while (this.runs.size() > 0) {
                    try {
                        this.doPass(this.runs);
                    }
                    catch (Exception e) {
                        throw new HyracksDataException((Throwable)e);
                    }
                }
                this.inFrames.clear();
            }
        }
        catch (Exception e) {
            this.writer.fail();
            throw new HyracksDataException((Throwable)e);
        }
        finally {
            this.aggregateState.close();
            this.writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPass(LinkedList<RunFileReader> runs) throws HyracksDataException {
        int runNumber;
        FileReference newRun = null;
        IFrameWriter writer = this.writer;
        boolean finalPass = false;
        while (this.inFrames.size() + 2 < this.framesLimit) {
            this.inFrames.add(this.ctx.allocateFrame());
        }
        if (runs.size() + 2 <= this.framesLimit) {
            finalPass = true;
            this.runFrameLimit = (this.framesLimit - 2) / runs.size();
            runNumber = runs.size();
        } else {
            runNumber = this.framesLimit - 2;
            newRun = this.ctx.getJobletContext().createManagedWorkspaceFile(ExternalGroupOperatorDescriptor.class.getSimpleName());
            writer = new RunFileWriter(newRun, this.ctx.getIOManager());
            writer.open();
        }
        try {
            this.currentFrameIndexInRun = new int[runNumber];
            this.currentRunFrames = new int[runNumber];
            RunFileReader[] runFileReaders = new RunFileReader[runNumber];
            FrameTupleAccessor[] tupleAccessors = new FrameTupleAccessor[this.inFrames.size()];
            Comparator<ReferenceEntry> comparator = this.createEntryComparator(this.comparators);
            ReferencedPriorityQueue topTuples = new ReferencedPriorityQueue(this.ctx.getFrameSize(), this.outRecordDescriptor, runNumber, comparator, this.keyFields, this.nmkComputer);
            int[] tupleIndices = new int[runNumber];
            for (int i = 0; i < runNumber; ++i) {
                int frameIndex;
                int runIndex = topTuples.peek().getRunid();
                tupleIndices[runIndex] = 0;
                runFileReaders[runIndex] = runs.get(runIndex);
                runFileReaders[runIndex].open();
                this.currentRunFrames[runIndex] = 0;
                this.currentFrameIndexInRun[runIndex] = runIndex * this.runFrameLimit;
                for (int j = 0; j < this.runFrameLimit && runFileReaders[runIndex].nextFrame(this.inFrames.get(frameIndex = this.currentFrameIndexInRun[runIndex] + j)); ++j) {
                    tupleAccessors[frameIndex] = new FrameTupleAccessor(this.ctx.getFrameSize(), this.outRecordDescriptor);
                    tupleAccessors[frameIndex].reset(this.inFrames.get(frameIndex));
                    int n = runIndex;
                    this.currentRunFrames[n] = this.currentRunFrames[n] + 1;
                    if (j != 0) continue;
                    this.setNextTopTuple(runIndex, tupleIndices, runFileReaders, tupleAccessors, topTuples);
                }
            }
            while (!topTuples.areRunsExhausted()) {
                ReferenceEntry top = topTuples.peek();
                int tupleIndex = top.getTupleIndex();
                int runIndex = topTuples.peek().getRunid();
                FrameTupleAccessor fta = top.getAccessor();
                int currentTupleInOutFrame = this.outFrameAccessor.getTupleCount() - 1;
                if (currentTupleInOutFrame < 0 || this.compareFrameTuples((IFrameTupleAccessor)fta, tupleIndex, (IFrameTupleAccessor)this.outFrameAccessor, currentTupleInOutFrame) != 0) {
                    this.tupleBuilder.reset();
                    for (int k = 0; k < this.storedKeys.length; ++k) {
                        this.tupleBuilder.addField((IFrameTupleAccessor)fta, tupleIndex, this.storedKeys[k]);
                    }
                    this.aggregator.init(this.tupleBuilder, (IFrameTupleAccessor)fta, tupleIndex, this.aggregateState);
                    if (!this.outAppender.appendSkipEmptyField(this.tupleBuilder.getFieldEndOffsets(), this.tupleBuilder.getByteArray(), 0, this.tupleBuilder.getSize())) {
                        this.flushOutFrame(writer, finalPass);
                        if (!this.outAppender.appendSkipEmptyField(this.tupleBuilder.getFieldEndOffsets(), this.tupleBuilder.getByteArray(), 0, this.tupleBuilder.getSize())) {
                            throw new HyracksDataException("The partial result is too large to be initialized in a frame.");
                        }
                    }
                } else {
                    this.aggregator.aggregate((IFrameTupleAccessor)fta, tupleIndex, (IFrameTupleAccessor)this.outFrameAccessor, currentTupleInOutFrame, this.aggregateState);
                }
                int n = runIndex;
                tupleIndices[n] = tupleIndices[n] + 1;
                this.setNextTopTuple(runIndex, tupleIndices, runFileReaders, tupleAccessors, topTuples);
            }
            if (this.outAppender.getTupleCount() > 0) {
                this.flushOutFrame(writer, finalPass);
                this.outAppender.reset(this.outFrame, true);
            }
            this.aggregator.close();
            runs.subList(0, runNumber).clear();
            if (!finalPass) {
                runs.add(0, ((RunFileWriter)writer).createReader());
            }
        }
        finally {
            if (!finalPass) {
                writer.close();
            }
        }
    }

    private void flushOutFrame(IFrameWriter writer, boolean isFinal) throws HyracksDataException {
        if (this.finalTupleBuilder == null) {
            this.finalTupleBuilder = new ArrayTupleBuilder(this.outRecordDescriptor.getFields().length);
        }
        if (this.writerFrame == null) {
            this.writerFrame = this.ctx.allocateFrame();
        }
        if (this.writerAppender == null) {
            this.writerAppender = new FrameTupleAppender(this.ctx.getFrameSize());
            this.writerAppender.reset(this.writerFrame, true);
        }
        this.outFrameAccessor.reset(this.outFrame);
        for (int i = 0; i < this.outFrameAccessor.getTupleCount(); ++i) {
            this.finalTupleBuilder.reset();
            for (int k = 0; k < this.storedKeys.length; ++k) {
                this.finalTupleBuilder.addField((IFrameTupleAccessor)this.outFrameAccessor, i, this.storedKeys[k]);
            }
            if (isFinal) {
                this.aggregator.outputFinalResult(this.finalTupleBuilder, (IFrameTupleAccessor)this.outFrameAccessor, i, this.aggregateState);
            } else {
                this.aggregator.outputPartialResult(this.finalTupleBuilder, (IFrameTupleAccessor)this.outFrameAccessor, i, this.aggregateState);
            }
            if (this.writerAppender.appendSkipEmptyField(this.finalTupleBuilder.getFieldEndOffsets(), this.finalTupleBuilder.getByteArray(), 0, this.finalTupleBuilder.getSize())) continue;
            FrameUtils.flushFrame((ByteBuffer)this.writerFrame, (IFrameWriter)writer);
            this.writerAppender.reset(this.writerFrame, true);
            if (this.writerAppender.appendSkipEmptyField(this.finalTupleBuilder.getFieldEndOffsets(), this.finalTupleBuilder.getByteArray(), 0, this.finalTupleBuilder.getSize())) continue;
            throw new HyracksDataException("Aggregation output is too large to be fit into a frame.");
        }
        if (this.writerAppender.getTupleCount() > 0) {
            FrameUtils.flushFrame((ByteBuffer)this.writerFrame, (IFrameWriter)writer);
            this.writerAppender.reset(this.writerFrame, true);
        }
        this.outAppender.reset(this.outFrame, true);
    }

    private void setNextTopTuple(int runIndex, int[] tupleIndices, RunFileReader[] runCursors, FrameTupleAccessor[] tupleAccessors, ReferencedPriorityQueue topTuples) throws HyracksDataException {
        int runStart = runIndex * this.runFrameLimit;
        boolean existNext = false;
        if (tupleAccessors[this.currentFrameIndexInRun[runIndex]] == null || runCursors[runIndex] == null) {
            existNext = false;
        } else if (this.currentFrameIndexInRun[runIndex] - runStart < this.currentRunFrames[runIndex] - 1) {
            existNext = true;
            if (tupleIndices[runIndex] >= tupleAccessors[this.currentFrameIndexInRun[runIndex]].getTupleCount()) {
                tupleIndices[runIndex] = 0;
                int n = runIndex;
                this.currentFrameIndexInRun[n] = this.currentFrameIndexInRun[n] + 1;
            }
        } else if (tupleIndices[runIndex] < tupleAccessors[this.currentFrameIndexInRun[runIndex]].getTupleCount()) {
            existNext = true;
        } else {
            int frameIndex;
            tupleIndices[runIndex] = 0;
            this.currentFrameIndexInRun[runIndex] = runStart;
            this.currentRunFrames[runIndex] = 0;
            for (int j = 0; j < this.runFrameLimit && runCursors[runIndex].nextFrame(this.inFrames.get(frameIndex = this.currentFrameIndexInRun[runIndex] + j)); ++j) {
                tupleAccessors[frameIndex].reset(this.inFrames.get(frameIndex));
                existNext = true;
                int n = runIndex;
                this.currentRunFrames[n] = this.currentRunFrames[n] + 1;
            }
        }
        if (existNext) {
            topTuples.popAndReplace(tupleAccessors[this.currentFrameIndexInRun[runIndex]], tupleIndices[runIndex]);
        } else {
            topTuples.pop();
            this.closeRun(runIndex, runCursors, (IFrameTupleAccessor[])tupleAccessors);
        }
    }

    private void closeRun(int index, RunFileReader[] runCursors, IFrameTupleAccessor[] tupleAccessor) throws HyracksDataException {
        if (runCursors[index] != null) {
            runCursors[index].close();
            runCursors[index] = null;
            int frameOffset = index * this.runFrameLimit;
            for (int j = 0; j < this.runFrameLimit; ++j) {
                tupleAccessor[frameOffset + j] = null;
            }
        }
    }

    private int compareFrameTuples(IFrameTupleAccessor fta1, int j1, IFrameTupleAccessor fta2, int j2) {
        byte[] b1 = fta1.getBuffer().array();
        byte[] b2 = fta2.getBuffer().array();
        for (int f = 0; f < this.keyFields.length; ++f) {
            int fIdx = f;
            int s1 = fta1.getTupleStartOffset(j1) + fta1.getFieldSlotsLength() + fta1.getFieldStartOffset(j1, fIdx);
            int l1 = fta1.getFieldLength(j1, fIdx);
            int s2 = fta2.getTupleStartOffset(j2) + fta2.getFieldSlotsLength() + fta2.getFieldStartOffset(j2, fIdx);
            int l2_start = fta2.getFieldStartOffset(j2, fIdx);
            int l2_end = fta2.getFieldEndOffset(j2, fIdx);
            int l2 = l2_end - l2_start;
            int c = this.comparators[f].compare(b1, s1, l1, b2, s2, l2);
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    private Comparator<ReferenceEntry> createEntryComparator(final IBinaryComparator[] comparators) {
        return new Comparator<ReferenceEntry>(){

            @Override
            public int compare(ReferenceEntry o1, ReferenceEntry o2) {
                FrameTupleAccessor fta1 = o1.getAccessor();
                FrameTupleAccessor fta2 = o2.getAccessor();
                int j1 = o1.getTupleIndex();
                int j2 = o2.getTupleIndex();
                byte[] b1 = fta1.getBuffer().array();
                byte[] b2 = fta2.getBuffer().array();
                for (int f = 0; f < ExternalGroupMergeOperatorNodePushable.this.keyFields.length; ++f) {
                    int l2;
                    int s2;
                    int l1;
                    int fIdx = f;
                    int s1 = fta1.getTupleStartOffset(j1) + fta1.getFieldSlotsLength() + fta1.getFieldStartOffset(j1, fIdx);
                    int c = comparators[f].compare(b1, s1, l1 = fta1.getFieldEndOffset(j1, fIdx) - fta1.getFieldStartOffset(j1, fIdx), b2, s2 = fta2.getTupleStartOffset(j2) + fta2.getFieldSlotsLength() + fta2.getFieldStartOffset(j2, fIdx), l2 = fta2.getFieldEndOffset(j2, fIdx) - fta2.getFieldStartOffset(j2, fIdx));
                    if (c == 0) continue;
                    return c;
                }
                return 0;
            }
        };
    }
}

