/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.std.group.external;

import edu.uci.ics.hyracks.api.comm.IFrameWriter;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.state.IStateObject;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import edu.uci.ics.hyracks.api.dataflow.value.INormalizedKeyComputerFactory;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.api.io.FileReference;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import edu.uci.ics.hyracks.dataflow.common.io.RunFileReader;
import edu.uci.ics.hyracks.dataflow.common.io.RunFileWriter;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractUnaryInputSinkOperatorNodePushable;
import edu.uci.ics.hyracks.dataflow.std.group.IAggregatorDescriptorFactory;
import edu.uci.ics.hyracks.dataflow.std.group.ISpillableTable;
import edu.uci.ics.hyracks.dataflow.std.group.ISpillableTableFactory;
import edu.uci.ics.hyracks.dataflow.std.group.external.ExternalGroupOperatorDescriptor;
import edu.uci.ics.hyracks.dataflow.std.group.external.ExternalGroupState;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;

class ExternalGroupBuildOperatorNodePushable
extends AbstractUnaryInputSinkOperatorNodePushable {
    private final IHyracksTaskContext ctx;
    private final Object stateId;
    private final int[] keyFields;
    private final IBinaryComparatorFactory[] comparatorFactories;
    private final INormalizedKeyComputerFactory firstNormalizerFactory;
    private final IAggregatorDescriptorFactory aggregatorFactory;
    private final int framesLimit;
    private final ISpillableTableFactory spillableTableFactory;
    private final RecordDescriptor inRecordDescriptor;
    private final RecordDescriptor outRecordDescriptor;
    private final FrameTupleAccessor accessor;
    private ExternalGroupState state;

    ExternalGroupBuildOperatorNodePushable(IHyracksTaskContext ctx, Object stateId, int[] keyFields, int framesLimit, IBinaryComparatorFactory[] comparatorFactories, INormalizedKeyComputerFactory firstNormalizerFactory, IAggregatorDescriptorFactory aggregatorFactory, RecordDescriptor inRecordDescriptor, RecordDescriptor outRecordDescriptor, ISpillableTableFactory spillableTableFactory) {
        this.ctx = ctx;
        this.stateId = stateId;
        this.framesLimit = framesLimit;
        this.aggregatorFactory = aggregatorFactory;
        this.keyFields = keyFields;
        this.comparatorFactories = comparatorFactories;
        this.firstNormalizerFactory = firstNormalizerFactory;
        this.spillableTableFactory = spillableTableFactory;
        this.inRecordDescriptor = inRecordDescriptor;
        this.outRecordDescriptor = outRecordDescriptor;
        this.accessor = new FrameTupleAccessor(ctx.getFrameSize(), inRecordDescriptor);
    }

    public void open() throws HyracksDataException {
        this.state = new ExternalGroupState(this.ctx.getJobletContext().getJobId(), this.stateId);
        this.state.setRuns(new LinkedList<RunFileReader>());
        ISpillableTable table = this.spillableTableFactory.buildSpillableTable(this.ctx, this.keyFields, this.comparatorFactories, this.firstNormalizerFactory, this.aggregatorFactory, this.inRecordDescriptor, this.outRecordDescriptor, this.framesLimit);
        table.reset();
        this.state.setSpillableTable(table);
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.accessor.reset(buffer);
        int tupleCount = this.accessor.getTupleCount();
        ISpillableTable gTable = this.state.getSpillableTable();
        for (int i = 0; i < tupleCount; ++i) {
            if (gTable.insert(this.accessor, i)) continue;
            this.flushFramesToRun();
            if (gTable.insert(this.accessor, i)) continue;
            throw new HyracksDataException("Failed to insert a new buffer into the aggregate operator!");
        }
    }

    public void fail() throws HyracksDataException {
    }

    public void close() throws HyracksDataException {
        ISpillableTable gTable = this.state.getSpillableTable();
        if (gTable.getFrameCount() >= 0 && this.state.getRuns().size() > 0) {
            this.flushFramesToRun();
            gTable.close();
            gTable = null;
        }
        this.ctx.setStateObject((IStateObject)this.state);
    }

    private void flushFramesToRun() throws HyracksDataException {
        FileReference runFile;
        try {
            runFile = this.ctx.getJobletContext().createManagedWorkspaceFile(ExternalGroupOperatorDescriptor.class.getSimpleName());
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
        RunFileWriter writer = new RunFileWriter(runFile, this.ctx.getIOManager());
        writer.open();
        ISpillableTable gTable = this.state.getSpillableTable();
        try {
            gTable.sortFrames();
            gTable.flushFrames((IFrameWriter)writer, true);
        }
        catch (Exception ex) {
            throw new HyracksDataException((Throwable)ex);
        }
        finally {
            writer.close();
        }
        gTable.reset();
        this.state.getRuns().add(writer.createReader());
    }
}

