/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.std.group.aggregators;

import edu.uci.ics.hyracks.api.comm.IFrameTupleAccessor;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import edu.uci.ics.hyracks.dataflow.std.group.AbstractAccumulatingAggregatorDescriptorFactory;
import edu.uci.ics.hyracks.dataflow.std.group.AggregateState;
import edu.uci.ics.hyracks.dataflow.std.group.IAggregatorDescriptor;
import edu.uci.ics.hyracks.dataflow.std.group.IFieldAggregateDescriptor;
import edu.uci.ics.hyracks.dataflow.std.group.IFieldAggregateDescriptorFactory;
import java.io.DataOutput;

public class MultiFieldsAggregatorFactory
extends AbstractAccumulatingAggregatorDescriptorFactory {
    private static final long serialVersionUID = 1L;
    private final IFieldAggregateDescriptorFactory[] aggregatorFactories;
    private int[] keys;

    public MultiFieldsAggregatorFactory(int[] keys, IFieldAggregateDescriptorFactory[] aggregatorFactories) {
        this.keys = keys;
        this.aggregatorFactories = aggregatorFactories;
    }

    public MultiFieldsAggregatorFactory(IFieldAggregateDescriptorFactory[] aggregatorFactories) {
        this.aggregatorFactories = aggregatorFactories;
    }

    @Override
    public IAggregatorDescriptor createAggregator(IHyracksTaskContext ctx, RecordDescriptor inRecordDescriptor, RecordDescriptor outRecordDescriptor, int[] keyFields, int[] keyFieldsInPartialResults) throws HyracksDataException {
        final IFieldAggregateDescriptor[] aggregators = new IFieldAggregateDescriptor[this.aggregatorFactories.length];
        for (int i = 0; i < aggregators.length; ++i) {
            aggregators[i] = this.aggregatorFactories[i].createAggregator(ctx, inRecordDescriptor, outRecordDescriptor);
        }
        if (this.keys == null) {
            this.keys = keyFields;
        }
        return new IAggregatorDescriptor(){

            @Override
            public void reset() {
                for (int i = 0; i < aggregators.length; ++i) {
                    aggregators[i].reset();
                }
            }

            @Override
            public boolean outputPartialResult(ArrayTupleBuilder tupleBuilder, IFrameTupleAccessor accessor, int tIndex, AggregateState state) throws HyracksDataException {
                DataOutput dos = tupleBuilder.getDataOutput();
                int tupleOffset = accessor.getTupleStartOffset(tIndex);
                for (int i = 0; i < aggregators.length; ++i) {
                    int fieldOffset = accessor.getFieldStartOffset(tIndex, MultiFieldsAggregatorFactory.this.keys.length + i);
                    aggregators[i].outputPartialResult(dos, accessor.getBuffer().array(), fieldOffset + accessor.getFieldSlotsLength() + tupleOffset, ((AggregateState[])state.state)[i]);
                    tupleBuilder.addFieldEndOffset();
                }
                return true;
            }

            @Override
            public boolean outputFinalResult(ArrayTupleBuilder tupleBuilder, IFrameTupleAccessor accessor, int tIndex, AggregateState state) throws HyracksDataException {
                DataOutput dos = tupleBuilder.getDataOutput();
                int tupleOffset = accessor.getTupleStartOffset(tIndex);
                for (int i = 0; i < aggregators.length; ++i) {
                    if (aggregators[i].needsBinaryState()) {
                        int fieldOffset = accessor.getFieldStartOffset(tIndex, MultiFieldsAggregatorFactory.this.keys.length + i);
                        aggregators[i].outputFinalResult(dos, accessor.getBuffer().array(), tupleOffset + accessor.getFieldSlotsLength() + fieldOffset, ((AggregateState[])state.state)[i]);
                    } else {
                        aggregators[i].outputFinalResult(dos, null, 0, ((AggregateState[])state.state)[i]);
                    }
                    tupleBuilder.addFieldEndOffset();
                }
                return true;
            }

            @Override
            public void init(ArrayTupleBuilder tupleBuilder, IFrameTupleAccessor accessor, int tIndex, AggregateState state) throws HyracksDataException {
                DataOutput dos = tupleBuilder.getDataOutput();
                for (int i = 0; i < aggregators.length; ++i) {
                    aggregators[i].init(accessor, tIndex, dos, ((AggregateState[])state.state)[i]);
                    if (!aggregators[i].needsBinaryState()) continue;
                    tupleBuilder.addFieldEndOffset();
                }
            }

            @Override
            public AggregateState createAggregateStates() {
                AggregateState[] states = new AggregateState[aggregators.length];
                for (int i = 0; i < states.length; ++i) {
                    states[i] = aggregators[i].createState();
                }
                return new AggregateState(states);
            }

            @Override
            public void close() {
                for (int i = 0; i < aggregators.length; ++i) {
                    aggregators[i].close();
                }
            }

            @Override
            public void aggregate(IFrameTupleAccessor accessor, int tIndex, IFrameTupleAccessor stateAccessor, int stateTupleIndex, AggregateState state) throws HyracksDataException {
                if (stateAccessor != null) {
                    int stateTupleOffset = stateAccessor.getTupleStartOffset(stateTupleIndex);
                    int fieldIndex = 0;
                    for (int i = 0; i < aggregators.length; ++i) {
                        if (aggregators[i].needsBinaryState()) {
                            int stateFieldOffset = stateAccessor.getFieldStartOffset(stateTupleIndex, MultiFieldsAggregatorFactory.this.keys.length + fieldIndex);
                            aggregators[i].aggregate(accessor, tIndex, stateAccessor.getBuffer().array(), stateTupleOffset + stateAccessor.getFieldSlotsLength() + stateFieldOffset, ((AggregateState[])state.state)[i]);
                            ++fieldIndex;
                            continue;
                        }
                        aggregators[i].aggregate(accessor, tIndex, null, 0, ((AggregateState[])state.state)[i]);
                    }
                } else {
                    for (int i = 0; i < aggregators.length; ++i) {
                        aggregators[i].aggregate(accessor, tIndex, null, 0, ((AggregateState[])state.state)[i]);
                    }
                }
            }
        };
    }
}

