/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.std.group.aggregators;

import edu.uci.ics.hyracks.api.comm.IFrameTupleAccessor;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.dataflow.common.data.marshalling.IntegerSerializerDeserializer;
import edu.uci.ics.hyracks.dataflow.common.data.marshalling.UTF8StringSerializerDeserializer;
import edu.uci.ics.hyracks.dataflow.std.group.AggregateState;
import edu.uci.ics.hyracks.dataflow.std.group.IFieldAggregateDescriptor;
import edu.uci.ics.hyracks.dataflow.std.group.IFieldAggregateDescriptorFactory;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;

public class MinMaxStringFieldAggregatorFactory
implements IFieldAggregateDescriptorFactory {
    private static final long serialVersionUID = 1L;
    private final int aggField;
    private final boolean isMax;
    private final boolean hasBinaryState;

    public MinMaxStringFieldAggregatorFactory(int aggField, boolean isMax, boolean hasBinaryState) {
        this.aggField = aggField;
        this.isMax = isMax;
        this.hasBinaryState = hasBinaryState;
    }

    @Override
    public IFieldAggregateDescriptor createAggregator(IHyracksTaskContext ctx, RecordDescriptor inRecordDescriptor, RecordDescriptor outRecordDescriptor) throws HyracksDataException {
        return new IFieldAggregateDescriptor(){

            @Override
            public void reset() {
            }

            @Override
            public void outputPartialResult(DataOutput fieldOutput, byte[] data, int offset, AggregateState state) throws HyracksDataException {
                try {
                    if (MinMaxStringFieldAggregatorFactory.this.hasBinaryState) {
                        int stateIdx = IntegerSerializerDeserializer.getInt((byte[])data, (int)offset);
                        Object[] storedState = (Object[])state.state;
                        fieldOutput.writeUTF((String)storedState[stateIdx]);
                    } else {
                        fieldOutput.writeUTF((String)state.state);
                    }
                }
                catch (IOException e) {
                    throw new HyracksDataException("I/O exception when writing a string to the output writer in MinMaxStringAggregatorFactory.");
                }
            }

            @Override
            public void outputFinalResult(DataOutput fieldOutput, byte[] data, int offset, AggregateState state) throws HyracksDataException {
                try {
                    if (MinMaxStringFieldAggregatorFactory.this.hasBinaryState) {
                        int stateIdx = IntegerSerializerDeserializer.getInt((byte[])data, (int)offset);
                        Object[] storedState = (Object[])state.state;
                        fieldOutput.writeUTF((String)storedState[stateIdx]);
                    } else {
                        fieldOutput.writeUTF((String)state.state);
                    }
                }
                catch (IOException e) {
                    throw new HyracksDataException("I/O exception when writing a string to the output writer in MinMaxStringAggregatorFactory.");
                }
            }

            @Override
            public void init(IFrameTupleAccessor accessor, int tIndex, DataOutput fieldOutput, AggregateState state) throws HyracksDataException {
                int tupleOffset = accessor.getTupleStartOffset(tIndex);
                int fieldStart = accessor.getFieldStartOffset(tIndex, MinMaxStringFieldAggregatorFactory.this.aggField);
                int fieldLength = accessor.getFieldLength(tIndex, MinMaxStringFieldAggregatorFactory.this.aggField);
                String strField = UTF8StringSerializerDeserializer.INSTANCE.deserialize((DataInput)new DataInputStream(new ByteArrayInputStream(accessor.getBuffer().array(), tupleOffset + accessor.getFieldSlotsLength() + fieldStart, fieldLength)));
                if (MinMaxStringFieldAggregatorFactory.this.hasBinaryState) {
                    Object[] storedState;
                    if (state.state == null) {
                        storedState = new Object[8];
                        storedState[0] = new Integer(0);
                        state.state = storedState;
                    } else {
                        storedState = (Object[])state.state;
                    }
                    int stateCount = (Integer)storedState[0];
                    if (stateCount + 1 >= storedState.length) {
                        state.state = storedState = Arrays.copyOf(storedState, storedState.length * 2);
                    }
                    storedState[0] = ++stateCount;
                    storedState[stateCount] = strField;
                    try {
                        fieldOutput.writeInt(stateCount);
                    }
                    catch (IOException e) {
                        throw new HyracksDataException(e.fillInStackTrace());
                    }
                } else {
                    state.state = strField;
                }
            }

            @Override
            public void close() {
            }

            @Override
            public void aggregate(IFrameTupleAccessor accessor, int tIndex, byte[] data, int offset, AggregateState state) throws HyracksDataException {
                int tupleOffset = accessor.getTupleStartOffset(tIndex);
                int fieldStart = accessor.getFieldStartOffset(tIndex, MinMaxStringFieldAggregatorFactory.this.aggField);
                int fieldLength = accessor.getFieldLength(tIndex, MinMaxStringFieldAggregatorFactory.this.aggField);
                String strField = UTF8StringSerializerDeserializer.INSTANCE.deserialize((DataInput)new DataInputStream(new ByteArrayInputStream(accessor.getBuffer().array(), tupleOffset + accessor.getFieldSlotsLength() + fieldStart, fieldLength)));
                if (MinMaxStringFieldAggregatorFactory.this.hasBinaryState) {
                    int stateIdx = IntegerSerializerDeserializer.getInt((byte[])data, (int)offset);
                    Object[] storedState = (Object[])state.state;
                    if (MinMaxStringFieldAggregatorFactory.this.isMax) {
                        if (strField.length() > ((String)storedState[stateIdx]).length()) {
                            storedState[stateIdx] = strField;
                        }
                    } else if (strField.length() < ((String)storedState[stateIdx]).length()) {
                        storedState[stateIdx] = strField;
                    }
                } else if (MinMaxStringFieldAggregatorFactory.this.isMax) {
                    if (strField.length() > ((String)state.state).length()) {
                        state.state = strField;
                    }
                } else if (strField.length() < ((String)state.state).length()) {
                    state.state = strField;
                }
            }

            @Override
            public boolean needsObjectState() {
                return true;
            }

            @Override
            public boolean needsBinaryState() {
                return MinMaxStringFieldAggregatorFactory.this.hasBinaryState;
            }

            @Override
            public AggregateState createState() {
                return new AggregateState();
            }
        };
    }
}

