/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.std.group.aggregators;

import edu.uci.ics.hyracks.api.comm.IFrameTupleAccessor;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.dataflow.common.data.marshalling.IntegerSerializerDeserializer;
import edu.uci.ics.hyracks.dataflow.std.group.AggregateState;
import edu.uci.ics.hyracks.dataflow.std.group.IFieldAggregateDescriptor;
import edu.uci.ics.hyracks.dataflow.std.group.IFieldAggregateDescriptorFactory;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;

public class AvgFieldMergeAggregatorFactory
implements IFieldAggregateDescriptorFactory {
    private static final long serialVersionUID = 1L;
    private final int aggField;
    private final boolean useObjectState;

    public AvgFieldMergeAggregatorFactory(int aggField, boolean useObjectState) {
        this.aggField = aggField;
        this.useObjectState = useObjectState;
    }

    @Override
    public IFieldAggregateDescriptor createAggregator(IHyracksTaskContext ctx, RecordDescriptor inRecordDescriptor, RecordDescriptor outRecordDescriptor) throws HyracksDataException {
        return new IFieldAggregateDescriptor(){

            @Override
            public void reset() {
            }

            @Override
            public void outputPartialResult(DataOutput fieldOutput, byte[] data, int offset, AggregateState state) throws HyracksDataException {
                int count;
                int sum;
                if (!AvgFieldMergeAggregatorFactory.this.useObjectState) {
                    sum = IntegerSerializerDeserializer.getInt((byte[])data, (int)offset);
                    count = IntegerSerializerDeserializer.getInt((byte[])data, (int)(offset + 4));
                } else {
                    Integer[] fields = (Integer[])state.state;
                    sum = fields[0];
                    count = fields[1];
                }
                try {
                    fieldOutput.writeInt(sum);
                    fieldOutput.writeInt(count);
                }
                catch (IOException e) {
                    throw new HyracksDataException("I/O exception when writing aggregation to the output buffer.");
                }
            }

            @Override
            public void outputFinalResult(DataOutput fieldOutput, byte[] data, int offset, AggregateState state) throws HyracksDataException {
                int count;
                int sum;
                if (!AvgFieldMergeAggregatorFactory.this.useObjectState) {
                    sum = IntegerSerializerDeserializer.getInt((byte[])data, (int)offset);
                    count = IntegerSerializerDeserializer.getInt((byte[])data, (int)(offset + 4));
                } else {
                    Integer[] fields = (Integer[])state.state;
                    sum = fields[0];
                    count = fields[1];
                }
                try {
                    fieldOutput.writeFloat((float)sum / (float)count);
                }
                catch (IOException e) {
                    throw new HyracksDataException("I/O exception when writing aggregation to the output buffer.");
                }
            }

            @Override
            public void close() {
            }

            @Override
            public void aggregate(IFrameTupleAccessor accessor, int tIndex, byte[] data, int offset, AggregateState state) throws HyracksDataException {
                int sum = 0;
                int count = 0;
                int tupleOffset = accessor.getTupleStartOffset(tIndex);
                int fieldStart = accessor.getFieldStartOffset(tIndex, AvgFieldMergeAggregatorFactory.this.aggField);
                sum += IntegerSerializerDeserializer.getInt((byte[])accessor.getBuffer().array(), (int)(tupleOffset + accessor.getFieldSlotsLength() + fieldStart));
                ++count;
                if (!AvgFieldMergeAggregatorFactory.this.useObjectState) {
                    ByteBuffer buf = ByteBuffer.wrap(data);
                    buf.putInt(offset, sum += buf.getInt(offset));
                    buf.putInt(offset + 4, count += buf.getInt(offset + 4));
                } else {
                    Integer[] fields = (Integer[])state.state;
                    state.state = new Integer[]{sum += fields[0].intValue(), count += fields[1].intValue()};
                }
            }

            @Override
            public boolean needsObjectState() {
                return AvgFieldMergeAggregatorFactory.this.useObjectState;
            }

            @Override
            public boolean needsBinaryState() {
                return !AvgFieldMergeAggregatorFactory.this.useObjectState;
            }

            @Override
            public AggregateState createState() {
                return new AggregateState(new Integer[]{0, 0});
            }

            @Override
            public void init(IFrameTupleAccessor accessor, int tIndex, DataOutput fieldOutput, AggregateState state) throws HyracksDataException {
                int sum = 0;
                int count = 0;
                int tupleOffset = accessor.getTupleStartOffset(tIndex);
                int fieldStart = accessor.getFieldStartOffset(tIndex, AvgFieldMergeAggregatorFactory.this.aggField);
                sum += IntegerSerializerDeserializer.getInt((byte[])accessor.getBuffer().array(), (int)(tupleOffset + accessor.getFieldSlotsLength() + fieldStart));
                count += IntegerSerializerDeserializer.getInt((byte[])accessor.getBuffer().array(), (int)(tupleOffset + accessor.getFieldSlotsLength() + fieldStart + 4));
                if (!AvgFieldMergeAggregatorFactory.this.useObjectState) {
                    try {
                        fieldOutput.writeInt(sum);
                        fieldOutput.writeInt(count);
                    }
                    catch (IOException e) {
                        throw new HyracksDataException("I/O exception when initializing the aggregator.");
                    }
                } else {
                    state.state = new Integer[]{sum, count};
                }
            }
        };
    }
}

