/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.std.group;

import edu.uci.ics.hyracks.api.comm.IFrameTupleAccessor;
import edu.uci.ics.hyracks.api.comm.IFrameWriter;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryComparator;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import edu.uci.ics.hyracks.api.dataflow.value.INormalizedKeyComputer;
import edu.uci.ics.hyracks.api.dataflow.value.INormalizedKeyComputerFactory;
import edu.uci.ics.hyracks.api.dataflow.value.ISerializerDeserializer;
import edu.uci.ics.hyracks.api.dataflow.value.ITuplePartitionComputer;
import edu.uci.ics.hyracks.api.dataflow.value.ITuplePartitionComputerFactory;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTuplePairComparator;
import edu.uci.ics.hyracks.dataflow.common.comm.util.FrameUtils;
import edu.uci.ics.hyracks.dataflow.std.group.AggregateState;
import edu.uci.ics.hyracks.dataflow.std.group.IAggregatorDescriptor;
import edu.uci.ics.hyracks.dataflow.std.group.IAggregatorDescriptorFactory;
import edu.uci.ics.hyracks.dataflow.std.group.ISpillableTable;
import edu.uci.ics.hyracks.dataflow.std.group.ISpillableTableFactory;
import edu.uci.ics.hyracks.dataflow.std.structures.ISerializableTable;
import edu.uci.ics.hyracks.dataflow.std.structures.SerializableHashTable;
import edu.uci.ics.hyracks.dataflow.std.structures.TuplePointer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class HashSpillableTableFactory
implements ISpillableTableFactory {
    private static final long serialVersionUID = 1L;
    private final ITuplePartitionComputerFactory tpcf;
    private final int tableSize;

    public HashSpillableTableFactory(ITuplePartitionComputerFactory tpcf, int tableSize) {
        this.tpcf = tpcf;
        this.tableSize = tableSize;
    }

    @Override
    public ISpillableTable buildSpillableTable(final IHyracksTaskContext ctx, final int[] keyFields, IBinaryComparatorFactory[] comparatorFactories, INormalizedKeyComputerFactory firstKeyNormalizerFactory, IAggregatorDescriptorFactory aggregateFactory, RecordDescriptor inRecordDescriptor, RecordDescriptor outRecordDescriptor, final int framesLimit) throws HyracksDataException {
        final int[] storedKeys = new int[keyFields.length];
        ISerializerDeserializer[] storedKeySerDeser = new ISerializerDeserializer[keyFields.length];
        for (int i = 0; i < keyFields.length; ++i) {
            storedKeys[i] = i;
            storedKeySerDeser[i] = inRecordDescriptor.getFields()[keyFields[i]];
        }
        RecordDescriptor internalRecordDescriptor = outRecordDescriptor;
        final FrameTupleAccessor storedKeysAccessor1 = new FrameTupleAccessor(ctx.getFrameSize(), internalRecordDescriptor);
        final FrameTupleAccessor storedKeysAccessor2 = new FrameTupleAccessor(ctx.getFrameSize(), internalRecordDescriptor);
        IBinaryComparator[] comparators = new IBinaryComparator[comparatorFactories.length];
        for (int i = 0; i < comparatorFactories.length; ++i) {
            comparators[i] = comparatorFactories[i].createBinaryComparator();
        }
        final FrameTuplePairComparator ftpcPartial = new FrameTuplePairComparator(keyFields, storedKeys, comparators);
        final FrameTuplePairComparator ftpcTuple = new FrameTuplePairComparator(storedKeys, storedKeys, comparators);
        final ITuplePartitionComputer tpc = this.tpcf.createPartitioner();
        final INormalizedKeyComputer nkc = firstKeyNormalizerFactory == null ? null : firstKeyNormalizerFactory.createNormalizedKeyComputer();
        int[] keyFieldsInPartialResults = new int[keyFields.length];
        for (int i = 0; i < keyFieldsInPartialResults.length; ++i) {
            keyFieldsInPartialResults[i] = i;
        }
        final IAggregatorDescriptor aggregator = aggregateFactory.createAggregator(ctx, inRecordDescriptor, outRecordDescriptor, keyFields, keyFieldsInPartialResults, null);
        final AggregateState aggregateState = aggregator.createAggregateStates();
        final ArrayTupleBuilder stateTupleBuilder = keyFields.length < outRecordDescriptor.getFields().length ? new ArrayTupleBuilder(outRecordDescriptor.getFields().length) : new ArrayTupleBuilder(outRecordDescriptor.getFields().length + 1);
        final ArrayTupleBuilder outputTupleBuilder = new ArrayTupleBuilder(outRecordDescriptor.getFields().length);
        return new ISpillableTable(){
            private int lastBufIndex;
            private ByteBuffer outputFrame;
            private FrameTupleAppender outputAppender;
            private FrameTupleAppender stateAppender;
            private final ISerializableTable table;
            private final TuplePointer storedTuplePointer;
            private final List<ByteBuffer> frames;
            private int[] tPointers;
            {
                this.stateAppender = new FrameTupleAppender(ctx.getFrameSize());
                this.table = new SerializableHashTable(HashSpillableTableFactory.this.tableSize, ctx);
                this.storedTuplePointer = new TuplePointer();
                this.frames = new ArrayList<ByteBuffer>();
            }

            @Override
            public void sortFrames() {
                int sfIdx = storedKeys[0];
                int totalTCount = this.table.getTupleCount();
                this.tPointers = new int[totalTCount * 3];
                int ptr = 0;
                block0: for (int i = 0; i < HashSpillableTableFactory.this.tableSize; ++i) {
                    int entry = i;
                    int offset = 0;
                    while (true) {
                        this.table.getTuplePointer(entry, offset, this.storedTuplePointer);
                        if (this.storedTuplePointer.frameIndex < 0) continue block0;
                        this.tPointers[ptr * 3] = entry;
                        this.tPointers[ptr * 3 + 1] = offset;
                        this.table.getTuplePointer(entry, offset, this.storedTuplePointer);
                        int fIndex = this.storedTuplePointer.frameIndex;
                        int tIndex = this.storedTuplePointer.tupleIndex;
                        storedKeysAccessor1.reset(this.frames.get(fIndex));
                        int tStart = storedKeysAccessor1.getTupleStartOffset(tIndex);
                        int f0StartRel = storedKeysAccessor1.getFieldStartOffset(tIndex, sfIdx);
                        int f0EndRel = storedKeysAccessor1.getFieldEndOffset(tIndex, sfIdx);
                        int f0Start = f0StartRel + tStart + storedKeysAccessor1.getFieldSlotsLength();
                        this.tPointers[ptr * 3 + 2] = nkc == null ? 0 : nkc.normalize(storedKeysAccessor1.getBuffer().array(), f0Start, f0EndRel - f0StartRel);
                        ++ptr;
                        ++offset;
                    }
                }
                if (this.tPointers.length > 0) {
                    this.sort(this.tPointers, 0, totalTCount);
                }
            }

            @Override
            public void reset() {
                this.lastBufIndex = -1;
                this.tPointers = null;
                this.table.reset();
                aggregator.reset();
            }

            @Override
            public boolean insert(FrameTupleAccessor accessor, int tIndex) throws HyracksDataException {
                boolean foundGroup;
                int entry;
                block8: {
                    int c;
                    if (this.lastBufIndex < 0) {
                        this.nextAvailableFrame();
                    }
                    entry = tpc.partition((IFrameTupleAccessor)accessor, tIndex, HashSpillableTableFactory.this.tableSize);
                    foundGroup = false;
                    int offset = 0;
                    do {
                        this.table.getTuplePointer(entry, offset++, this.storedTuplePointer);
                        if (this.storedTuplePointer.frameIndex < 0) break block8;
                        storedKeysAccessor1.reset(this.frames.get(this.storedTuplePointer.frameIndex));
                    } while ((c = ftpcPartial.compare(accessor, tIndex, storedKeysAccessor1, this.storedTuplePointer.tupleIndex)) != 0);
                    foundGroup = true;
                }
                if (!foundGroup) {
                    stateTupleBuilder.reset();
                    for (int k = 0; k < keyFields.length; ++k) {
                        stateTupleBuilder.addField((IFrameTupleAccessor)accessor, tIndex, keyFields[k]);
                    }
                    aggregator.init(stateTupleBuilder, (IFrameTupleAccessor)accessor, tIndex, aggregateState);
                    if (!this.stateAppender.appendSkipEmptyField(stateTupleBuilder.getFieldEndOffsets(), stateTupleBuilder.getByteArray(), 0, stateTupleBuilder.getSize())) {
                        if (!this.nextAvailableFrame()) {
                            return false;
                        }
                        if (!this.stateAppender.appendSkipEmptyField(stateTupleBuilder.getFieldEndOffsets(), stateTupleBuilder.getByteArray(), 0, stateTupleBuilder.getSize())) {
                            throw new HyracksDataException("Cannot init external aggregate state in a frame.");
                        }
                    }
                    this.storedTuplePointer.frameIndex = this.lastBufIndex;
                    this.storedTuplePointer.tupleIndex = this.stateAppender.getTupleCount() - 1;
                    this.table.insert(entry, this.storedTuplePointer);
                } else {
                    aggregator.aggregate((IFrameTupleAccessor)accessor, tIndex, (IFrameTupleAccessor)storedKeysAccessor1, this.storedTuplePointer.tupleIndex, aggregateState);
                }
                return true;
            }

            @Override
            public List<ByteBuffer> getFrames() {
                return this.frames;
            }

            @Override
            public int getFrameCount() {
                return this.lastBufIndex;
            }

            /*
             * Unable to fully structure code
             */
            @Override
            public void flushFrames(IFrameWriter writer, boolean isPartial) throws HyracksDataException {
                block13: {
                    if (this.outputFrame == null) {
                        this.outputFrame = ctx.allocateFrame();
                    }
                    if (this.outputAppender == null) {
                        this.outputAppender = new FrameTupleAppender(this.outputFrame.capacity());
                    }
                    this.outputAppender.reset(this.outputFrame, true);
                    if (this.tPointers != null) break block13;
                    block0: for (i = 0; i < HashSpillableTableFactory.access$000(HashSpillableTableFactory.this); ++i) {
                        entry = i;
                        offset = 0;
                        do lbl-1000:
                        // 3 sources

                        {
                            this.table.getTuplePointer(entry, offset++, this.storedTuplePointer);
                            if (this.storedTuplePointer.frameIndex < 0) continue block0;
                            bIndex = this.storedTuplePointer.frameIndex;
                            tIndex = this.storedTuplePointer.tupleIndex;
                            storedKeysAccessor1.reset(this.frames.get(bIndex));
                            outputTupleBuilder.reset();
                            for (k = 0; k < storedKeys.length; ++k) {
                                outputTupleBuilder.addField((IFrameTupleAccessor)storedKeysAccessor1, tIndex, storedKeys[k]);
                            }
                            if (isPartial) {
                                aggregator.outputPartialResult(outputTupleBuilder, (IFrameTupleAccessor)storedKeysAccessor1, tIndex, aggregateState);
                            } else {
                                aggregator.outputFinalResult(outputTupleBuilder, (IFrameTupleAccessor)storedKeysAccessor1, tIndex, aggregateState);
                            }
                            if (this.outputAppender.appendSkipEmptyField(outputTupleBuilder.getFieldEndOffsets(), outputTupleBuilder.getByteArray(), 0, outputTupleBuilder.getSize())) ** GOTO lbl-1000
                            FrameUtils.flushFrame((ByteBuffer)this.outputFrame, (IFrameWriter)writer);
                            this.outputAppender.reset(this.outputFrame, true);
                        } while (this.outputAppender.appendSkipEmptyField(outputTupleBuilder.getFieldEndOffsets(), outputTupleBuilder.getByteArray(), 0, outputTupleBuilder.getSize()));
                        throw new HyracksDataException("The output item is too large to be fit into a frame.");
                    }
                    if (this.outputAppender.getTupleCount() > 0) {
                        FrameUtils.flushFrame((ByteBuffer)this.outputFrame, (IFrameWriter)writer);
                        this.outputAppender.reset(this.outputFrame, true);
                    }
                    aggregator.close();
                    return;
                }
                n = this.tPointers.length / 3;
                for (ptr = 0; ptr < n; ++ptr) {
                    tableIndex = this.tPointers[ptr * 3];
                    rowIndex = this.tPointers[ptr * 3 + 1];
                    this.table.getTuplePointer(tableIndex, rowIndex, this.storedTuplePointer);
                    frameIndex = this.storedTuplePointer.frameIndex;
                    tupleIndex = this.storedTuplePointer.tupleIndex;
                    buffer = this.frames.get(frameIndex);
                    storedKeysAccessor1.reset(buffer);
                    outputTupleBuilder.reset();
                    for (k = 0; k < storedKeys.length; ++k) {
                        outputTupleBuilder.addField((IFrameTupleAccessor)storedKeysAccessor1, tupleIndex, storedKeys[k]);
                    }
                    if (isPartial) {
                        aggregator.outputPartialResult(outputTupleBuilder, (IFrameTupleAccessor)storedKeysAccessor1, tupleIndex, aggregateState);
                    } else {
                        aggregator.outputFinalResult(outputTupleBuilder, (IFrameTupleAccessor)storedKeysAccessor1, tupleIndex, aggregateState);
                    }
                    if (this.outputAppender.appendSkipEmptyField(outputTupleBuilder.getFieldEndOffsets(), outputTupleBuilder.getByteArray(), 0, outputTupleBuilder.getSize())) continue;
                    FrameUtils.flushFrame((ByteBuffer)this.outputFrame, (IFrameWriter)writer);
                    this.outputAppender.reset(this.outputFrame, true);
                    if (this.outputAppender.appendSkipEmptyField(outputTupleBuilder.getFieldEndOffsets(), outputTupleBuilder.getByteArray(), 0, outputTupleBuilder.getSize())) continue;
                    throw new HyracksDataException("The output item is too large to be fit into a frame.");
                }
                if (this.outputAppender.getTupleCount() > 0) {
                    FrameUtils.flushFrame((ByteBuffer)this.outputFrame, (IFrameWriter)writer);
                    this.outputAppender.reset(this.outputFrame, true);
                }
                aggregator.close();
            }

            @Override
            public void close() {
                this.lastBufIndex = -1;
                this.tPointers = null;
                this.table.close();
                this.frames.clear();
                aggregateState.close();
            }

            private boolean nextAvailableFrame() throws HyracksDataException {
                if (this.lastBufIndex + 1 >= framesLimit) {
                    return false;
                }
                if (this.frames.size() < framesLimit) {
                    ByteBuffer frame = ctx.allocateFrame();
                    frame.position(0);
                    frame.limit(frame.capacity());
                    this.frames.add(frame);
                    this.stateAppender.reset(frame, true);
                    this.lastBufIndex = this.frames.size() - 1;
                } else {
                    ++this.lastBufIndex;
                    ByteBuffer frame = this.frames.get(this.lastBufIndex);
                    frame.position(0);
                    frame.limit(frame.capacity());
                    this.stateAppender.reset(frame, true);
                }
                return true;
            }

            private void sort(int[] tPointers, int offset, int length) {
                int c;
                int a;
                int m = offset + (length >> 1);
                int mTable = tPointers[m * 3];
                int mRow = tPointers[m * 3 + 1];
                int mNormKey = tPointers[m * 3 + 2];
                this.table.getTuplePointer(mTable, mRow, this.storedTuplePointer);
                int mFrame = this.storedTuplePointer.frameIndex;
                int mTuple = this.storedTuplePointer.tupleIndex;
                storedKeysAccessor1.reset(this.frames.get(mFrame));
                int b = a = offset;
                int d = c = offset + length - 1;
                while (true) {
                    int cmp;
                    if (b <= c) {
                        int bTable = tPointers[b * 3];
                        int bRow = tPointers[b * 3 + 1];
                        int bNormKey = tPointers[b * 3 + 2];
                        cmp = 0;
                        if (bNormKey != mNormKey) {
                            cmp = ((long)bNormKey & 0xFFFFFFFFL) < ((long)mNormKey & 0xFFFFFFFFL) ? -1 : 1;
                        } else {
                            this.table.getTuplePointer(bTable, bRow, this.storedTuplePointer);
                            int bFrame = this.storedTuplePointer.frameIndex;
                            int bTuple = this.storedTuplePointer.tupleIndex;
                            storedKeysAccessor2.reset(this.frames.get(bFrame));
                            cmp = ftpcTuple.compare(storedKeysAccessor2, bTuple, storedKeysAccessor1, mTuple);
                        }
                        if (cmp <= 0) {
                            if (cmp == 0) {
                                this.swap(tPointers, a++, b);
                            }
                            ++b;
                            continue;
                        }
                    }
                    while (c >= b) {
                        int cTable = tPointers[c * 3];
                        int cRow = tPointers[c * 3 + 1];
                        int cNormKey = tPointers[c * 3 + 2];
                        cmp = 0;
                        if (cNormKey != mNormKey) {
                            cmp = ((long)cNormKey & 0xFFFFFFFFL) < ((long)mNormKey & 0xFFFFFFFFL) ? -1 : 1;
                        } else {
                            this.table.getTuplePointer(cTable, cRow, this.storedTuplePointer);
                            int cFrame = this.storedTuplePointer.frameIndex;
                            int cTuple = this.storedTuplePointer.tupleIndex;
                            storedKeysAccessor2.reset(this.frames.get(cFrame));
                            cmp = ftpcTuple.compare(storedKeysAccessor2, cTuple, storedKeysAccessor1, mTuple);
                        }
                        if (cmp < 0) break;
                        if (cmp == 0) {
                            this.swap(tPointers, c, d--);
                        }
                        --c;
                    }
                    if (b > c) break;
                    this.swap(tPointers, b++, c--);
                }
                int n = offset + length;
                int s = Math.min(a - offset, b - a);
                this.vecswap(tPointers, offset, b - s, s);
                s = Math.min(d - c, n - d - 1);
                this.vecswap(tPointers, b, n - s, s);
                s = b - a;
                if (s > 1) {
                    this.sort(tPointers, offset, s);
                }
                if ((s = d - c) > 1) {
                    this.sort(tPointers, n - s, s);
                }
            }

            private void swap(int[] x, int a, int b) {
                for (int i = 0; i < 3; ++i) {
                    int t = x[a * 3 + i];
                    x[a * 3 + i] = x[b * 3 + i];
                    x[b * 3 + i] = t;
                }
            }

            private void vecswap(int[] x, int a, int b, int n) {
                int i = 0;
                while (i < n) {
                    this.swap(x, a, b);
                    ++i;
                    ++a;
                    ++b;
                }
            }
        };
    }
}

