/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.std.group;

import edu.uci.ics.hyracks.api.comm.FrameHelper;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import java.nio.ByteBuffer;

public class FrameToolsForGroupers {
    public static void writeFields(byte[] buf, int offset, int length, ArrayTupleBuilder tupleBuilder) throws HyracksDataException {
        FrameToolsForGroupers.writeFields(buf, offset, length, tupleBuilder.getFieldEndOffsets(), tupleBuilder.getByteArray(), 0, tupleBuilder.getSize());
    }

    public static void writeFields(byte[] buf, int offset, int length, int[] fieldsOffset, byte[] data, int dataOffset, int dataLength) throws HyracksDataException {
        if (dataLength + 4 * fieldsOffset.length > length) {
            throw new HyracksDataException("Out of buffer bound: try to write too much data (" + dataLength + ") to the given bound (" + length + ").");
        }
        ByteBuffer buffer = ByteBuffer.wrap(buf, offset, length);
        for (int i = 0; i < fieldsOffset.length; ++i) {
            buffer.putInt(fieldsOffset[i]);
        }
        buffer.put(data, dataOffset, dataLength);
    }

    public static void updateFrameMetaForNewTuple(ByteBuffer buffer, int addedTupleLength) throws HyracksDataException {
        int currentTupleCount = buffer.getInt(FrameHelper.getTupleCountOffset((int)buffer.capacity()));
        int currentTupleEndOffset = buffer.getInt(FrameHelper.getTupleCountOffset((int)buffer.capacity()) - 4 * currentTupleCount);
        int newTupleEndOffset = currentTupleEndOffset + addedTupleLength;
        buffer.putInt(FrameHelper.getTupleCountOffset((int)buffer.capacity()) - 4 * (currentTupleCount + 1), newTupleEndOffset);
        buffer.putInt(FrameHelper.getTupleCountOffset((int)buffer.capacity()), currentTupleCount + 1);
    }

    public static void updateFrameMetaForNewTuple(ByteBuffer buffer, int addedTupleLength, boolean isReset) throws HyracksDataException {
        int currentTupleEndOffset;
        int currentTupleCount;
        if (isReset) {
            currentTupleCount = 0;
            currentTupleEndOffset = 0;
        } else {
            currentTupleCount = buffer.getInt(FrameHelper.getTupleCountOffset((int)buffer.capacity()));
            currentTupleEndOffset = buffer.getInt(FrameHelper.getTupleCountOffset((int)buffer.capacity()) - 4 * currentTupleCount);
        }
        int newTupleEndOffset = currentTupleEndOffset + addedTupleLength;
        buffer.putInt(FrameHelper.getTupleCountOffset((int)buffer.capacity()) - 4 * (currentTupleCount + 1), newTupleEndOffset);
        buffer.putInt(FrameHelper.getTupleCountOffset((int)buffer.capacity()), currentTupleCount + 1);
    }

    public static boolean isFrameOverflowing(ByteBuffer buffer, int length, boolean isReset) throws HyracksDataException {
        int currentTupleCount = buffer.getInt(FrameHelper.getTupleCountOffset((int)buffer.capacity()));
        if (currentTupleCount == 0 || isReset) {
            return length + 4 + 4 > buffer.capacity();
        }
        int currentTupleEndOffset = buffer.getInt(FrameHelper.getTupleCountOffset((int)buffer.capacity()) - 4 * currentTupleCount);
        return currentTupleEndOffset + length + 4 + (currentTupleCount + 1) * 4 > buffer.capacity();
    }
}

