/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.std.file;

import edu.uci.ics.hyracks.dataflow.std.file.IRecordWriter;
import edu.uci.ics.hyracks.dataflow.std.util.StringSerializationUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public abstract class RecordWriter
implements IRecordWriter {
    protected final BufferedWriter bufferedWriter;
    protected final int[] columns;
    protected final char separator;
    public static final char COMMA = ',';

    public RecordWriter(Object[] args) throws Exception {
        OutputStream outputStream = this.createOutputStream(args);
        this.bufferedWriter = outputStream != null ? new BufferedWriter(new OutputStreamWriter(this.createOutputStream(args))) : null;
        this.columns = null;
        this.separator = (char)44;
    }

    public RecordWriter(int[] columns, char separator, Object[] args) throws Exception {
        OutputStream outputStream = this.createOutputStream(args);
        this.bufferedWriter = outputStream != null ? new BufferedWriter(new OutputStreamWriter(outputStream)) : null;
        this.columns = columns;
        this.separator = separator;
    }

    @Override
    public void close() {
        try {
            this.bufferedWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void write(Object[] record) throws Exception {
        if (this.columns == null) {
            for (int i = 0; i < record.length; ++i) {
                if (i != 0) {
                    this.bufferedWriter.write(this.separator);
                }
                this.bufferedWriter.write(StringSerializationUtils.toString(record[i]));
            }
        } else {
            for (int i = 0; i < this.columns.length; ++i) {
                if (i != 0) {
                    this.bufferedWriter.write(this.separator);
                }
                this.bufferedWriter.write(StringSerializationUtils.toString(record[this.columns[i]]));
            }
        }
        this.bufferedWriter.write("\n");
    }

    public abstract OutputStream createOutputStream(Object[] var1) throws Exception;
}

