/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.std.file;

import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.IOperatorNodePushable;
import edu.uci.ics.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.api.job.IOperatorDescriptorRegistry;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import edu.uci.ics.hyracks.dataflow.common.comm.util.ByteBufferInputStream;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractSingleActivityOperatorDescriptor;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractUnaryInputSinkOperatorNodePushable;
import edu.uci.ics.hyracks.dataflow.std.file.FileSplit;
import edu.uci.ics.hyracks.dataflow.std.file.IFileSplitProvider;
import java.io.BufferedWriter;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class PlainFileWriterOperatorDescriptor
extends AbstractSingleActivityOperatorDescriptor {
    private static final long serialVersionUID = 1L;
    private IFileSplitProvider fileSplitProvider;
    private String delim;

    public PlainFileWriterOperatorDescriptor(IOperatorDescriptorRegistry spec, IFileSplitProvider fileSplitProvider, String delim) {
        super(spec, 1, 0);
        this.fileSplitProvider = fileSplitProvider;
        this.delim = delim;
    }

    public IOperatorNodePushable createPushRuntime(IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, final int partition, int nPartitions) throws HyracksDataException {
        final FileSplit[] splits = this.fileSplitProvider.getFileSplits();
        final FrameTupleAccessor frameTupleAccessor = new FrameTupleAccessor(ctx.getFrameSize(), recordDescProvider.getInputRecordDescriptor(this.getActivityId(), 0));
        final RecordDescriptor recordDescriptor = recordDescProvider.getInputRecordDescriptor(this.getActivityId(), 0);
        return new AbstractUnaryInputSinkOperatorNodePushable(){
            private BufferedWriter out;
            private ByteBufferInputStream bbis;
            private DataInputStream di;

            public void open() throws HyracksDataException {
                try {
                    this.out = new BufferedWriter(new FileWriter(splits[partition].getLocalFile().getFile()));
                    this.bbis = new ByteBufferInputStream();
                    this.di = new DataInputStream((InputStream)this.bbis);
                }
                catch (Exception e) {
                    throw new HyracksDataException((Throwable)e);
                }
            }

            public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                try {
                    frameTupleAccessor.reset(buffer);
                    for (int tIndex = 0; tIndex < frameTupleAccessor.getTupleCount(); ++tIndex) {
                        int start = frameTupleAccessor.getTupleStartOffset(tIndex) + frameTupleAccessor.getFieldSlotsLength();
                        this.bbis.setByteBuffer(buffer, start);
                        Object[] record = new Object[recordDescriptor.getFieldCount()];
                        for (int i = 0; i < record.length; ++i) {
                            Object instance = recordDescriptor.getFields()[i].deserialize((DataInput)this.di);
                            if (i == 0) {
                                this.out.write(String.valueOf(instance));
                                continue;
                            }
                            this.out.write(PlainFileWriterOperatorDescriptor.this.delim + String.valueOf(instance));
                        }
                        this.out.write("\n");
                    }
                }
                catch (IOException ex) {
                    throw new HyracksDataException((Throwable)ex);
                }
            }

            public void fail() throws HyracksDataException {
            }

            public void close() throws HyracksDataException {
                try {
                    this.out.close();
                }
                catch (IOException e) {
                    throw new HyracksDataException((Throwable)e);
                }
            }
        };
    }
}

