/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.std.file;

import edu.uci.ics.hyracks.api.job.IOperatorDescriptorRegistry;
import edu.uci.ics.hyracks.dataflow.std.file.AbstractFileWriteOperatorDescriptor;
import edu.uci.ics.hyracks.dataflow.std.file.FileSplit;
import edu.uci.ics.hyracks.dataflow.std.file.IRecordWriter;
import edu.uci.ics.hyracks.dataflow.std.file.RecordWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class LineFileWriteOperatorDescriptor
extends AbstractFileWriteOperatorDescriptor {
    private static final long serialVersionUID = 1L;
    private int[] columns;
    private char separator;

    public LineFileWriteOperatorDescriptor(IOperatorDescriptorRegistry spec, FileSplit[] splits) {
        this(spec, splits, null, ',');
    }

    public LineFileWriteOperatorDescriptor(IOperatorDescriptorRegistry spec, FileSplit[] splits, int[] columns) {
        this(spec, splits, columns, ',');
    }

    public LineFileWriteOperatorDescriptor(IOperatorDescriptorRegistry spec, FileSplit[] splits, int[] columns, char separator) {
        super(spec, splits);
        this.columns = columns;
        this.separator = separator;
    }

    @Override
    protected IRecordWriter createRecordWriter(FileSplit fileSplit, int index) throws Exception {
        return new LineWriterImpl(fileSplit.getLocalFile().getFile(), this.columns, this.separator);
    }

    private static class LineWriterImpl
    extends RecordWriter {
        private static final long serialVersionUID = 1L;

        LineWriterImpl(File file, int[] columns, char separator) throws Exception {
            super(columns, separator, new Object[]{file});
        }

        @Override
        public OutputStream createOutputStream(Object[] args) throws Exception {
            return new FileOutputStream((File)args[0]);
        }
    }
}

