/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.std.file;

import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.IOperatorNodePushable;
import edu.uci.ics.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.api.job.IOperatorDescriptorRegistry;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractSingleActivityOperatorDescriptor;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractUnaryInputSinkOperatorNodePushable;
import edu.uci.ics.hyracks.dataflow.std.file.FileSplit;
import edu.uci.ics.hyracks.dataflow.std.file.IFileSplitProvider;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class FrameFileWriterOperatorDescriptor
extends AbstractSingleActivityOperatorDescriptor {
    private static final long serialVersionUID = 1L;
    private IFileSplitProvider fileSplitProvider;

    public FrameFileWriterOperatorDescriptor(IOperatorDescriptorRegistry spec, IFileSplitProvider fileSplitProvider) {
        super(spec, 1, 0);
        this.fileSplitProvider = fileSplitProvider;
    }

    public IOperatorNodePushable createPushRuntime(IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, final int partition, int nPartitions) {
        final FileSplit[] splits = this.fileSplitProvider.getFileSplits();
        return new AbstractUnaryInputSinkOperatorNodePushable(){
            private OutputStream out;

            public void open() throws HyracksDataException {
                try {
                    this.out = new FileOutputStream(splits[partition].getLocalFile().getFile());
                }
                catch (FileNotFoundException e) {
                    throw new HyracksDataException((Throwable)e);
                }
            }

            public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                try {
                    this.out.write(buffer.array());
                }
                catch (IOException e) {
                    throw new HyracksDataException((Throwable)e);
                }
            }

            public void fail() throws HyracksDataException {
            }

            public void close() throws HyracksDataException {
                try {
                    this.out.close();
                }
                catch (IOException e) {
                    throw new HyracksDataException((Throwable)e);
                }
            }
        };
    }
}

