/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.std.file;

import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.IOperatorNodePushable;
import edu.uci.ics.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.api.job.IOperatorDescriptorRegistry;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractSingleActivityOperatorDescriptor;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractUnaryOutputSourceOperatorNodePushable;
import edu.uci.ics.hyracks.dataflow.std.file.FileSplit;
import edu.uci.ics.hyracks.dataflow.std.file.IFileSplitProvider;
import edu.uci.ics.hyracks.dataflow.std.file.ITupleParser;
import edu.uci.ics.hyracks.dataflow.std.file.ITupleParserFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;

public class FileScanOperatorDescriptor
extends AbstractSingleActivityOperatorDescriptor {
    private static final long serialVersionUID = 1L;
    private final IFileSplitProvider fileSplitProvider;
    private final ITupleParserFactory tupleParserFactory;

    public FileScanOperatorDescriptor(IOperatorDescriptorRegistry spec, IFileSplitProvider fileSplitProvider, ITupleParserFactory tupleParserFactory, RecordDescriptor rDesc) {
        super(spec, 0, 1);
        this.fileSplitProvider = fileSplitProvider;
        this.tupleParserFactory = tupleParserFactory;
        this.recordDescriptors[0] = rDesc;
    }

    public IOperatorNodePushable createPushRuntime(IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, int partition, int nPartitions) throws HyracksDataException {
        final FileSplit split = this.fileSplitProvider.getFileSplits()[partition];
        final ITupleParser tp = this.tupleParserFactory.createTupleParser(ctx);
        return new AbstractUnaryOutputSourceOperatorNodePushable(){

            @Override
            public void initialize() throws HyracksDataException {
                File f = split.getLocalFile().getFile();
                this.writer.open();
                try {
                    FileInputStream in;
                    try {
                        in = new FileInputStream(f);
                    }
                    catch (FileNotFoundException e) {
                        this.writer.fail();
                        throw new HyracksDataException((Throwable)e);
                    }
                    tp.parse(in, this.writer);
                }
                catch (Exception e) {
                    this.writer.fail();
                    throw new HyracksDataException((Throwable)e);
                }
                finally {
                    this.writer.close();
                }
            }
        };
    }
}

