/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.std.file;

import edu.uci.ics.hyracks.api.comm.IFrameWriter;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.IOperatorNodePushable;
import edu.uci.ics.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.api.job.IOperatorDescriptorRegistry;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractOperatorNodePushable;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractSingleActivityOperatorDescriptor;
import edu.uci.ics.hyracks.dataflow.std.file.FileSplit;
import edu.uci.ics.hyracks.dataflow.std.file.IFileSplitProvider;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class FileRemoveOperatorDescriptor
extends AbstractSingleActivityOperatorDescriptor {
    private final IFileSplitProvider fileSplitProvider;
    private static final long serialVersionUID = 1L;

    public FileRemoveOperatorDescriptor(IOperatorDescriptorRegistry spec, IFileSplitProvider fileSplitProvder) {
        super(spec, 0, 0);
        this.fileSplitProvider = fileSplitProvder;
    }

    public IOperatorNodePushable createPushRuntime(IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, int partition, int nPartitions) throws HyracksDataException {
        final FileSplit split = this.fileSplitProvider.getFileSplits()[partition];
        return new AbstractOperatorNodePushable(){

            public void setOutputFrameWriter(int index, IFrameWriter writer, RecordDescriptor recordDesc) {
                throw new IllegalStateException();
            }

            public void initialize() throws HyracksDataException {
                File f = split.getLocalFile().getFile();
                try {
                    FileUtils.deleteDirectory((File)f);
                }
                catch (IOException e) {
                    throw new HyracksDataException((Throwable)e);
                }
            }

            public IFrameWriter getInputFrameWriter(int index) {
                throw new IllegalStateException();
            }

            public int getInputArity() {
                return 0;
            }

            public void deinitialize() throws HyracksDataException {
            }
        };
    }
}

