/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.std.file;

import edu.uci.ics.hyracks.api.comm.IFrameWriter;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import edu.uci.ics.hyracks.dataflow.common.comm.util.FrameUtils;
import edu.uci.ics.hyracks.dataflow.common.data.parsers.IValueParser;
import edu.uci.ics.hyracks.dataflow.common.data.parsers.IValueParserFactory;
import edu.uci.ics.hyracks.dataflow.std.file.ITupleParser;
import edu.uci.ics.hyracks.dataflow.std.file.ITupleParserFactory;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class DelimitedDataTupleParserFactory
implements ITupleParserFactory {
    private static final long serialVersionUID = 1L;
    private IValueParserFactory[] valueParserFactories;
    private char fieldDelimiter;

    public DelimitedDataTupleParserFactory(IValueParserFactory[] fieldParserFactories, char fieldDelimiter) {
        this.valueParserFactories = fieldParserFactories;
        this.fieldDelimiter = fieldDelimiter;
    }

    @Override
    public ITupleParser createTupleParser(final IHyracksTaskContext ctx) {
        return new ITupleParser(){

            @Override
            public void parse(InputStream in, IFrameWriter writer) throws HyracksDataException {
                try {
                    IValueParser[] valueParsers = new IValueParser[DelimitedDataTupleParserFactory.this.valueParserFactories.length];
                    for (int i = 0; i < DelimitedDataTupleParserFactory.this.valueParserFactories.length; ++i) {
                        valueParsers[i] = DelimitedDataTupleParserFactory.this.valueParserFactories[i].createValueParser();
                    }
                    ByteBuffer frame = ctx.allocateFrame();
                    FrameTupleAppender appender = new FrameTupleAppender(ctx.getFrameSize());
                    appender.reset(frame, true);
                    ArrayTupleBuilder tb = new ArrayTupleBuilder(valueParsers.length);
                    DataOutput dos = tb.getDataOutput();
                    FieldCursor cursor = new FieldCursor(new InputStreamReader(in));
                    while (cursor.nextRecord()) {
                        tb.reset();
                        for (int i = 0; i < valueParsers.length && cursor.nextField(); ++i) {
                            valueParsers[i].parse(cursor.buffer, cursor.fStart, cursor.fEnd - cursor.fStart, dos);
                            tb.addFieldEndOffset();
                        }
                        if (appender.append(tb.getFieldEndOffsets(), tb.getByteArray(), 0, tb.getSize())) continue;
                        FrameUtils.flushFrame((ByteBuffer)frame, (IFrameWriter)writer);
                        appender.reset(frame, true);
                        if (appender.append(tb.getFieldEndOffsets(), tb.getByteArray(), 0, tb.getSize())) continue;
                        throw new HyracksDataException("Record size (" + tb.getSize() + ") larger than frame size (" + appender.getBuffer().capacity() + ")");
                    }
                    if (appender.getTupleCount() > 0) {
                        FrameUtils.flushFrame((ByteBuffer)frame, (IFrameWriter)writer);
                    }
                }
                catch (IOException e) {
                    throw new HyracksDataException((Throwable)e);
                }
            }
        };
    }

    private class FieldCursor {
        private static final int INITIAL_BUFFER_SIZE = 4096;
        private static final int INCREMENT = 4096;
        private final Reader in;
        private char[] buffer;
        private int start;
        private int end;
        private State state;
        private int fStart;
        private int fEnd;

        public FieldCursor(Reader in) {
            this.in = in;
            this.buffer = new char[4096];
            this.start = 0;
            this.end = 0;
            this.state = State.INIT;
        }

        public boolean nextRecord() throws IOException {
            while (true) {
                block0 : switch (this.state) {
                    case INIT: {
                        boolean eof;
                        boolean bl = eof = !this.readMore();
                        if (eof) {
                            this.state = State.EOF;
                            return false;
                        }
                        this.state = State.IN_RECORD;
                        return true;
                    }
                    case IN_RECORD: {
                        char ch;
                        boolean eof;
                        int p = this.start;
                        while (true) {
                            if (p >= this.end) {
                                int s = this.start;
                                boolean bl = eof = !this.readMore();
                                if (eof) {
                                    this.state = State.EOF;
                                    return this.start < this.end;
                                }
                                p -= s - this.start;
                            }
                            if ((ch = this.buffer[p]) == '\n') {
                                this.start = p + 1;
                                this.state = State.EOR;
                                break block0;
                            }
                            if (ch == '\r') {
                                this.start = p + 1;
                                this.state = State.CR;
                                break block0;
                            }
                            ++p;
                        }
                    }
                    case CR: {
                        char ch;
                        boolean eof;
                        if (this.start >= this.end) {
                            boolean bl = eof = !this.readMore();
                            if (eof) {
                                this.state = State.EOF;
                                return false;
                            }
                        }
                        if ((ch = this.buffer[this.start]) == '\n') {
                            ++this.start;
                            this.state = State.EOR;
                        } else {
                            this.state = State.IN_RECORD;
                            return true;
                        }
                    }
                    case EOR: {
                        boolean eof;
                        if (this.start >= this.end) {
                            boolean bl = eof = !this.readMore();
                            if (eof) {
                                this.state = State.EOF;
                                return false;
                            }
                        }
                        this.state = State.IN_RECORD;
                        return this.start < this.end;
                    }
                    case EOF: {
                        return false;
                    }
                }
            }
        }

        public boolean nextField() throws IOException {
            switch (this.state) {
                case INIT: 
                case CR: 
                case EOR: 
                case EOF: {
                    return false;
                }
                case IN_RECORD: {
                    int p = this.start;
                    while (true) {
                        char ch;
                        if (p >= this.end) {
                            boolean eof;
                            int s = this.start;
                            boolean bl = eof = !this.readMore();
                            if (eof) {
                                this.state = State.EOF;
                                return true;
                            }
                            p -= s - this.start;
                        }
                        if ((ch = this.buffer[p]) == DelimitedDataTupleParserFactory.this.fieldDelimiter) {
                            this.fStart = this.start;
                            this.fEnd = p;
                            this.start = p + 1;
                            return true;
                        }
                        if (ch == '\n') {
                            this.fStart = this.start;
                            this.fEnd = p;
                            this.start = p + 1;
                            this.state = State.EOR;
                            return true;
                        }
                        if (ch == '\r') {
                            this.fStart = this.start;
                            this.fEnd = p;
                            this.start = p + 1;
                            this.state = State.CR;
                            return true;
                        }
                        ++p;
                    }
                }
            }
            throw new IllegalStateException();
        }

        private boolean readMore() throws IOException {
            int n;
            if (this.start > 0) {
                System.arraycopy(this.buffer, this.start, this.buffer, 0, this.end - this.start);
            }
            this.end -= this.start;
            this.start = 0;
            if (this.end == this.buffer.length) {
                this.buffer = Arrays.copyOf(this.buffer, this.buffer.length + 4096);
            }
            if ((n = this.in.read(this.buffer, this.end, this.buffer.length - this.end)) < 0) {
                return false;
            }
            this.end += n;
            return true;
        }
    }

    private static enum State {
        INIT,
        IN_RECORD,
        EOR,
        CR,
        EOF;

    }
}

