/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.std.file;

import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.IOpenableDataWriter;
import edu.uci.ics.hyracks.api.dataflow.IOperatorNodePushable;
import edu.uci.ics.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.api.job.IOperatorDescriptorRegistry;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractSingleActivityOperatorDescriptor;
import edu.uci.ics.hyracks.dataflow.std.base.IOpenableDataWriterOperator;
import edu.uci.ics.hyracks.dataflow.std.file.FileSplit;
import edu.uci.ics.hyracks.dataflow.std.file.IRecordWriter;
import edu.uci.ics.hyracks.dataflow.std.util.DeserializedOperatorNodePushable;

public abstract class AbstractFileWriteOperatorDescriptor
extends AbstractSingleActivityOperatorDescriptor {
    private static final long serialVersionUID = 1L;
    protected FileSplit[] splits;

    public FileSplit[] getSplits() {
        return this.splits;
    }

    public void setSplits(FileSplit[] splits) {
        this.splits = splits;
    }

    public AbstractFileWriteOperatorDescriptor(IOperatorDescriptorRegistry spec, FileSplit[] splits) {
        super(spec, 1, 0);
        this.splits = splits;
    }

    protected abstract IRecordWriter createRecordWriter(FileSplit var1, int var2) throws Exception;

    public IOperatorNodePushable createPushRuntime(IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, int partition, int nPartitions) {
        return new DeserializedOperatorNodePushable(ctx, new FileWriteOperator(partition), recordDescProvider.getInputRecordDescriptor(this.getActivityId(), 0));
    }

    protected class FileWriteOperator
    implements IOpenableDataWriterOperator {
        private int index;
        private IRecordWriter writer;

        FileWriteOperator(int index) {
            this.index = index;
        }

        @Override
        public void setDataWriter(int index, IOpenableDataWriter<Object[]> writer) {
            throw new IllegalArgumentException();
        }

        public void open() throws HyracksDataException {
            FileSplit split = AbstractFileWriteOperatorDescriptor.this.splits[this.index];
            try {
                this.writer = AbstractFileWriteOperatorDescriptor.this.createRecordWriter(split, this.index);
            }
            catch (Exception e) {
                throw new HyracksDataException((Throwable)e);
            }
        }

        public void close() throws HyracksDataException {
            this.writer.close();
        }

        public void fail() throws HyracksDataException {
        }

        public void writeData(Object[] data) throws HyracksDataException {
            try {
                this.writer.write(data);
            }
            catch (Exception e) {
                throw new HyracksDataException((Throwable)e);
            }
        }
    }
}

