/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.std.file;

import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.IOpenableDataWriter;
import edu.uci.ics.hyracks.api.dataflow.IOperatorNodePushable;
import edu.uci.ics.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.api.job.IOperatorDescriptorRegistry;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractSingleActivityOperatorDescriptor;
import edu.uci.ics.hyracks.dataflow.std.base.IOpenableDataWriterOperator;
import edu.uci.ics.hyracks.dataflow.std.file.FileSplit;
import edu.uci.ics.hyracks.dataflow.std.file.IRecordReader;
import edu.uci.ics.hyracks.dataflow.std.util.DeserializedOperatorNodePushable;
import java.io.File;

public abstract class AbstractDeserializedFileScanOperatorDescriptor
extends AbstractSingleActivityOperatorDescriptor {
    private static final long serialVersionUID = 1L;
    protected FileSplit[] splits;

    public AbstractDeserializedFileScanOperatorDescriptor(IOperatorDescriptorRegistry spec, FileSplit[] splits, RecordDescriptor recordDescriptor) {
        super(spec, 0, 1);
        this.recordDescriptors[0] = recordDescriptor;
        this.splits = splits;
    }

    protected abstract IRecordReader createRecordReader(File var1, RecordDescriptor var2) throws Exception;

    protected abstract void configure() throws Exception;

    public IOperatorNodePushable createPushRuntime(IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, int partition, int nPartitions) {
        return new DeserializedOperatorNodePushable(ctx, new DeserializedFileScanOperator(partition), null);
    }

    protected class DeserializedFileScanOperator
    implements IOpenableDataWriterOperator {
        private IOpenableDataWriter<Object[]> writer;
        private int index;

        DeserializedFileScanOperator(int index) {
            this.index = index;
        }

        @Override
        public void setDataWriter(int index, IOpenableDataWriter<Object[]> writer) {
            if (index != 0) {
                throw new IndexOutOfBoundsException("Invalid index: " + index);
            }
            this.writer = writer;
        }

        public void open() throws HyracksDataException {
            IRecordReader reader;
            FileSplit split = AbstractDeserializedFileScanOperatorDescriptor.this.splits[this.index];
            RecordDescriptor desc = AbstractDeserializedFileScanOperatorDescriptor.this.recordDescriptors[0];
            try {
                reader = AbstractDeserializedFileScanOperatorDescriptor.this.createRecordReader(split.getLocalFile().getFile(), desc);
            }
            catch (Exception e) {
                throw new HyracksDataException((Throwable)e);
            }
            if (desc == null) {
                desc = AbstractDeserializedFileScanOperatorDescriptor.this.recordDescriptors[0];
            }
            this.writer.open();
            try {
                Object[] record;
                while (reader.read(record = new Object[desc.getFieldCount()])) {
                    this.writer.writeData((Object)record);
                }
            }
            catch (Exception e) {
                this.writer.fail();
                throw new HyracksDataException((Throwable)e);
            }
            finally {
                reader.close();
                this.writer.close();
            }
        }

        public void close() throws HyracksDataException {
        }

        public void writeData(Object[] data) throws HyracksDataException {
            throw new UnsupportedOperationException();
        }

        public void fail() throws HyracksDataException {
        }
    }
}

