/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.std.connectors;

import edu.uci.ics.hyracks.api.application.ICCApplicationContext;
import edu.uci.ics.hyracks.api.comm.IFrameWriter;
import edu.uci.ics.hyracks.api.comm.IPartitionCollector;
import edu.uci.ics.hyracks.api.comm.IPartitionWriterFactory;
import edu.uci.ics.hyracks.api.constraints.Constraint;
import edu.uci.ics.hyracks.api.constraints.IConstraintAcceptor;
import edu.uci.ics.hyracks.api.constraints.expressions.ConstraintExpression;
import edu.uci.ics.hyracks.api.constraints.expressions.LValueConstraintExpression;
import edu.uci.ics.hyracks.api.constraints.expressions.PartitionCountExpression;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.OperatorDescriptorId;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.api.job.ActivityCluster;
import edu.uci.ics.hyracks.api.job.IConnectorDescriptorRegistry;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractConnectorDescriptor;
import edu.uci.ics.hyracks.dataflow.std.collectors.NonDeterministicChannelReader;
import edu.uci.ics.hyracks.dataflow.std.collectors.NonDeterministicFrameReader;
import edu.uci.ics.hyracks.dataflow.std.collectors.PartitionCollector;
import java.util.BitSet;

public class OneToOneConnectorDescriptor
extends AbstractConnectorDescriptor {
    private static final long serialVersionUID = 1L;

    public OneToOneConnectorDescriptor(IConnectorDescriptorRegistry spec) {
        super(spec);
    }

    public IFrameWriter createPartitioner(IHyracksTaskContext ctx, RecordDescriptor recordDesc, IPartitionWriterFactory edwFactory, int index, int nProducerPartitions, int nConsumerPartitions) throws HyracksDataException {
        return edwFactory.createFrameWriter(index);
    }

    public IPartitionCollector createPartitionCollector(IHyracksTaskContext ctx, RecordDescriptor recordDesc, int index, int nProducerPartitions, int nConsumerPartitions) throws HyracksDataException {
        BitSet expectedPartitions = new BitSet(nProducerPartitions);
        expectedPartitions.set(index);
        NonDeterministicChannelReader channelReader = new NonDeterministicChannelReader(nProducerPartitions, expectedPartitions);
        NonDeterministicFrameReader frameReader = new NonDeterministicFrameReader(channelReader);
        return new PartitionCollector(ctx, this.getConnectorId(), index, expectedPartitions, frameReader, channelReader);
    }

    @Override
    public void contributeSchedulingConstraints(IConstraintAcceptor constraintAcceptor, ActivityCluster ac, ICCApplicationContext appCtx) {
        OperatorDescriptorId consumer = ac.getConsumerActivity(this.getConnectorId()).getOperatorDescriptorId();
        OperatorDescriptorId producer = ac.getProducerActivity(this.getConnectorId()).getOperatorDescriptorId();
        constraintAcceptor.addConstraint(new Constraint((LValueConstraintExpression)new PartitionCountExpression(consumer), (ConstraintExpression)new PartitionCountExpression(producer)));
    }

    public void indicateTargetPartitions(int nProducerPartitions, int nConsumerPartitions, int producerIndex, BitSet targetBitmap) {
        targetBitmap.clear();
        targetBitmap.set(producerIndex);
    }

    public void indicateSourcePartitions(int nProducerPartitions, int nConsumerPartitions, int consumerIndex, BitSet sourceBitmap) {
        sourceBitmap.clear();
        sourceBitmap.set(consumerIndex);
    }

    public boolean allProducersToAllConsumers() {
        return false;
    }
}

