/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.std.connectors;

import edu.uci.ics.hyracks.api.comm.IFrameTupleAccessor;
import edu.uci.ics.hyracks.api.comm.IFrameWriter;
import edu.uci.ics.hyracks.api.comm.IPartitionWriterFactory;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.value.ITuplePartitionComputer;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import edu.uci.ics.hyracks.dataflow.std.connectors.ILocalityMap;
import java.io.IOException;
import java.nio.ByteBuffer;

public class LocalityAwarePartitionDataWriter
implements IFrameWriter {
    private final IFrameWriter[] pWriters;
    private final FrameTupleAppender[] appenders;
    private final FrameTupleAccessor tupleAccessor;
    private final ITuplePartitionComputer tpc;

    public LocalityAwarePartitionDataWriter(IHyracksTaskContext ctx, IPartitionWriterFactory pwFactory, RecordDescriptor recordDescriptor, ITuplePartitionComputer tpc, int nConsumerPartitions, ILocalityMap localityMap, int senderIndex) throws HyracksDataException {
        int[] consumerPartitions = localityMap.getConsumers(senderIndex, nConsumerPartitions);
        this.pWriters = new IFrameWriter[consumerPartitions.length];
        this.appenders = new FrameTupleAppender[consumerPartitions.length];
        for (int i = 0; i < consumerPartitions.length; ++i) {
            try {
                this.pWriters[i] = pwFactory.createFrameWriter(consumerPartitions[i]);
                this.appenders[i] = new FrameTupleAppender(ctx.getFrameSize());
                this.appenders[i].reset(ctx.allocateFrame(), true);
                continue;
            }
            catch (IOException e) {
                throw new HyracksDataException((Throwable)e);
            }
        }
        this.tupleAccessor = new FrameTupleAccessor(ctx.getFrameSize(), recordDescriptor);
        this.tpc = tpc;
    }

    public void open() throws HyracksDataException {
        for (int i = 0; i < this.pWriters.length; ++i) {
            this.pWriters[i].open();
            this.appenders[i].reset(this.appenders[i].getBuffer(), true);
        }
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.tupleAccessor.reset(buffer);
        int tupleCount = this.tupleAccessor.getTupleCount();
        for (int i = 0; i < tupleCount; ++i) {
            int h = this.pWriters.length == 1 ? 0 : this.tpc.partition((IFrameTupleAccessor)this.tupleAccessor, i, this.pWriters.length);
            FrameTupleAppender appender = this.appenders[h];
            if (appender.append((IFrameTupleAccessor)this.tupleAccessor, i)) continue;
            ByteBuffer appenderBuffer = appender.getBuffer();
            this.flushFrame(appenderBuffer, this.pWriters[h]);
            appender.reset(appenderBuffer, true);
            if (appender.append((IFrameTupleAccessor)this.tupleAccessor, i)) continue;
            throw new HyracksDataException("Record size (" + (this.tupleAccessor.getTupleEndOffset(i) - this.tupleAccessor.getTupleStartOffset(i)) + ") larger than frame size (" + appender.getBuffer().capacity() + ")");
        }
    }

    public void fail() throws HyracksDataException {
        for (int i = 0; i < this.appenders.length; ++i) {
            this.pWriters[i].fail();
        }
    }

    private void flushFrame(ByteBuffer buffer, IFrameWriter frameWriter) throws HyracksDataException {
        buffer.position(0);
        buffer.limit(buffer.capacity());
        frameWriter.nextFrame(buffer);
    }

    public void close() throws HyracksDataException {
        for (int i = 0; i < this.pWriters.length; ++i) {
            if (this.appenders[i].getTupleCount() > 0) {
                this.flushFrame(this.appenders[i].getBuffer(), this.pWriters[i]);
            }
            this.pWriters[i].close();
        }
    }
}

