/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.std.collectors;

import edu.uci.ics.hyracks.api.comm.IFrameReader;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryComparator;
import edu.uci.ics.hyracks.api.dataflow.value.INormalizedKeyComputer;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.dataflow.std.collectors.IPartitionBatchManager;
import edu.uci.ics.hyracks.dataflow.std.sort.RunMergingFrameReader;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class SortMergeFrameReader
implements IFrameReader {
    private IHyracksTaskContext ctx;
    private final int maxConcurrentMerges;
    private final int nSenders;
    private final int[] sortFields;
    private final IBinaryComparator[] comparators;
    private final INormalizedKeyComputer nmkComputer;
    private final RecordDescriptor recordDescriptor;
    private final IPartitionBatchManager pbm;
    private RunMergingFrameReader merger;

    public SortMergeFrameReader(IHyracksTaskContext ctx, int maxConcurrentMerges, int nSenders, int[] sortFields, IBinaryComparator[] comparators, INormalizedKeyComputer nmkComputer, RecordDescriptor recordDescriptor, IPartitionBatchManager pbm) {
        this.ctx = ctx;
        this.maxConcurrentMerges = maxConcurrentMerges;
        this.nSenders = nSenders;
        this.sortFields = sortFields;
        this.comparators = comparators;
        this.nmkComputer = nmkComputer;
        this.recordDescriptor = recordDescriptor;
        this.pbm = pbm;
    }

    public void open() throws HyracksDataException {
        ArrayList<ByteBuffer> inFrames;
        if (this.maxConcurrentMerges >= this.nSenders) {
            inFrames = new ArrayList<ByteBuffer>();
            for (int i = 0; i < this.nSenders; ++i) {
                inFrames.add(ByteBuffer.allocate(this.ctx.getFrameSize()));
            }
        } else {
            throw new HyracksDataException("Not yet supported");
        }
        ArrayList<IFrameReader> batch = new ArrayList<IFrameReader>();
        this.pbm.getNextBatch(batch, this.nSenders);
        this.merger = new RunMergingFrameReader(this.ctx, batch.toArray(new IFrameReader[this.nSenders]), inFrames, this.sortFields, this.comparators, this.nmkComputer, this.recordDescriptor);
        this.merger.open();
    }

    public boolean nextFrame(ByteBuffer buffer) throws HyracksDataException {
        buffer.position(buffer.capacity());
        buffer.limit(buffer.capacity());
        return this.merger.nextFrame(buffer);
    }

    public void close() throws HyracksDataException {
        this.merger.close();
    }
}

