/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.std.collectors;

import edu.uci.ics.hyracks.api.channels.IInputChannel;
import edu.uci.ics.hyracks.api.comm.IFrameReader;
import edu.uci.ics.hyracks.api.comm.PartitionChannel;
import edu.uci.ics.hyracks.api.context.IHyracksCommonContext;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.ConnectorDescriptorId;
import edu.uci.ics.hyracks.api.exceptions.HyracksException;
import edu.uci.ics.hyracks.api.partitions.PartitionId;
import edu.uci.ics.hyracks.dataflow.std.collectors.AbstractPartitionCollector;
import edu.uci.ics.hyracks.dataflow.std.collectors.IPartitionAcceptor;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;

public class PartitionCollector
extends AbstractPartitionCollector {
    private final BitSet expectedPartitions;
    private final IFrameReader frameReader;
    private final IPartitionAcceptor pa;

    public PartitionCollector(IHyracksTaskContext ctx, ConnectorDescriptorId connectorId, int receiverIndex, BitSet expectedPartitions, IFrameReader frameReader, IPartitionAcceptor pa) {
        super(ctx, connectorId, receiverIndex);
        this.expectedPartitions = expectedPartitions;
        this.frameReader = frameReader;
        this.pa = pa;
    }

    public void open() throws HyracksException {
    }

    public void addPartitions(Collection<PartitionChannel> partitions) throws HyracksException {
        for (PartitionChannel pc : partitions) {
            PartitionId pid = pc.getPartitionId();
            IInputChannel channel = pc.getInputChannel();
            this.pa.addPartition(pid, channel);
            channel.open((IHyracksCommonContext)this.ctx);
        }
    }

    public IFrameReader getReader() throws HyracksException {
        return this.frameReader;
    }

    public void close() throws HyracksException {
    }

    public Collection<PartitionId> getRequiredPartitionIds() throws HyracksException {
        ArrayList<PartitionId> c = new ArrayList<PartitionId>(this.expectedPartitions.cardinality());
        int i = this.expectedPartitions.nextSetBit(0);
        while (i >= 0) {
            c.add(new PartitionId(this.getJobId(), this.getConnectorId(), i, this.getReceiverIndex()));
            i = this.expectedPartitions.nextSetBit(i + 1);
        }
        return c;
    }

    public void abort() {
    }
}

