/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.std.collectors;

import edu.uci.ics.hyracks.api.channels.IInputChannel;
import edu.uci.ics.hyracks.api.channels.IInputChannelMonitor;
import edu.uci.ics.hyracks.api.comm.IFrameReader;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.api.partitions.PartitionId;
import edu.uci.ics.hyracks.dataflow.std.collectors.IPartitionBatchManager;
import edu.uci.ics.hyracks.dataflow.std.collectors.InputChannelFrameReader;
import java.util.ArrayList;
import java.util.List;

public class NonDeterministicPartitionBatchManager
implements IPartitionBatchManager {
    private final IInputChannel[] channels;
    private List<IFrameReader> partitions;
    private List<IFrameReader> batch;
    private int requiredSize;

    public NonDeterministicPartitionBatchManager(int nSenders) {
        this.channels = new IInputChannel[nSenders];
        this.partitions = new ArrayList<IFrameReader>();
    }

    @Override
    public synchronized void addPartition(PartitionId pid, IInputChannel channel) {
        this.channels[pid.getSenderIndex()] = channel;
        InputChannelFrameReader channelReader = new InputChannelFrameReader(channel);
        channel.registerMonitor((IInputChannelMonitor)channelReader);
        if (this.batch != null && this.batch.size() < this.requiredSize) {
            this.batch.add(channelReader);
            if (this.batch.size() == this.requiredSize) {
                this.notifyAll();
            }
        } else {
            this.partitions.add(channelReader);
        }
    }

    @Override
    public synchronized void getNextBatch(List<IFrameReader> batch, int size) throws HyracksDataException {
        if (this.partitions.size() <= size) {
            batch.addAll(this.partitions);
            this.partitions.clear();
        } else if (this.partitions.size() > size) {
            List<IFrameReader> sublist = this.partitions.subList(0, size);
            batch.addAll(sublist);
            sublist.clear();
        }
        if (batch.size() == size) {
            return;
        }
        this.batch = batch;
        this.requiredSize = size;
        while (batch.size() < size) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw new HyracksDataException((Throwable)e);
            }
        }
        this.batch = null;
    }
}

