/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.std.collectors;

import edu.uci.ics.hyracks.api.channels.IInputChannel;
import edu.uci.ics.hyracks.api.comm.IFrameReader;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.dataflow.common.comm.util.FrameUtils;
import edu.uci.ics.hyracks.dataflow.std.collectors.NonDeterministicChannelReader;
import java.nio.ByteBuffer;

public class NonDeterministicFrameReader
implements IFrameReader {
    private final NonDeterministicChannelReader channelReader;

    public NonDeterministicFrameReader(NonDeterministicChannelReader channelReader) {
        this.channelReader = channelReader;
    }

    public void open() throws HyracksDataException {
        this.channelReader.open();
    }

    public boolean nextFrame(ByteBuffer buffer) throws HyracksDataException {
        int index = this.channelReader.findNextSender();
        if (index >= 0) {
            IInputChannel[] channels = this.channelReader.getChannels();
            ByteBuffer srcFrame = channels[index].getNextBuffer();
            FrameUtils.copy((ByteBuffer)srcFrame, (ByteBuffer)buffer);
            channels[index].recycleBuffer(srcFrame);
            return true;
        }
        return false;
    }

    public synchronized void close() throws HyracksDataException {
        this.channelReader.close();
    }
}

