/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.std.collectors;

import edu.uci.ics.hyracks.api.channels.IInputChannel;
import edu.uci.ics.hyracks.api.channels.IInputChannelMonitor;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.api.partitions.PartitionId;
import edu.uci.ics.hyracks.dataflow.std.collectors.IPartitionAcceptor;
import java.util.BitSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NonDeterministicChannelReader
implements IInputChannelMonitor,
IPartitionAcceptor {
    private static final Logger LOGGER = Logger.getLogger(NonDeterministicChannelReader.class.getName());
    private final int nSenderPartitions;
    private final IInputChannel[] channels;
    private final BitSet frameAvailability;
    private final int[] availableFrameCounts;
    private final BitSet eosSenders;
    private final BitSet failSenders;
    private final BitSet closedSenders;
    private int lastReadSender;

    public NonDeterministicChannelReader(int nSenderPartitions, BitSet expectedPartitions) {
        this.nSenderPartitions = nSenderPartitions;
        this.channels = new IInputChannel[nSenderPartitions];
        this.eosSenders = new BitSet(nSenderPartitions);
        this.failSenders = new BitSet(nSenderPartitions);
        this.closedSenders = new BitSet(nSenderPartitions);
        this.closedSenders.or(expectedPartitions);
        this.closedSenders.flip(0, nSenderPartitions);
        this.frameAvailability = new BitSet(nSenderPartitions);
        this.availableFrameCounts = new int[nSenderPartitions];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPartition(PartitionId pid, IInputChannel channel) {
        channel.registerMonitor((IInputChannelMonitor)this);
        channel.setAttachment((Object)pid);
        NonDeterministicChannelReader nonDeterministicChannelReader = this;
        synchronized (nonDeterministicChannelReader) {
            this.channels[pid.getSenderIndex()] = channel;
        }
    }

    public int getSenderPartitionCount() {
        return this.nSenderPartitions;
    }

    public void open() throws HyracksDataException {
        this.lastReadSender = -1;
    }

    public IInputChannel[] getChannels() {
        return this.channels;
    }

    public synchronized int findNextSender() throws HyracksDataException {
        while (true) {
            this.lastReadSender = this.frameAvailability.nextSetBit(this.lastReadSender + 1);
            if (this.lastReadSender < 0) {
                this.lastReadSender = this.frameAvailability.nextSetBit(0);
            }
            if (this.lastReadSender >= 0) {
                assert (this.availableFrameCounts[this.lastReadSender] > 0);
                int n = this.lastReadSender;
                this.availableFrameCounts[n] = this.availableFrameCounts[n] - 1;
                if (this.availableFrameCounts[n] == 0) {
                    this.frameAvailability.clear(this.lastReadSender);
                }
                return this.lastReadSender;
            }
            if (!this.failSenders.isEmpty()) {
                throw new HyracksDataException("Failure occurred on input");
            }
            int i = this.eosSenders.nextSetBit(0);
            while (i >= 0) {
                this.channels[i].close();
                this.eosSenders.clear(i);
                this.closedSenders.set(i);
                i = this.eosSenders.nextSetBit(i);
            }
            int nextClosedBitIndex = this.closedSenders.nextClearBit(0);
            if (nextClosedBitIndex < 0 || nextClosedBitIndex >= this.nSenderPartitions) {
                this.lastReadSender = -1;
                return this.lastReadSender;
            }
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw new HyracksDataException((Throwable)e);
            }
        }
    }

    public synchronized void close() throws HyracksDataException {
        int i = this.closedSenders.nextClearBit(0);
        while (i >= 0 && i < this.nSenderPartitions) {
            if (this.channels[i] != null) {
                this.channels[i].close();
                this.channels[i] = null;
            }
            i = this.closedSenders.nextClearBit(i + 1);
        }
    }

    public synchronized void notifyFailure(IInputChannel channel) {
        PartitionId pid = (PartitionId)channel.getAttachment();
        int senderIndex = pid.getSenderIndex();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Failure: " + pid.getConnectorDescriptorId() + " sender: " + senderIndex + " receiver: " + pid.getReceiverIndex());
        }
        this.failSenders.set(senderIndex);
        this.eosSenders.set(senderIndex);
        this.notifyAll();
    }

    public synchronized void notifyDataAvailability(IInputChannel channel, int nFrames) {
        PartitionId pid = (PartitionId)channel.getAttachment();
        int senderIndex = pid.getSenderIndex();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Data available: " + pid.getConnectorDescriptorId() + " sender: " + senderIndex + " receiver: " + pid.getReceiverIndex());
        }
        int n = senderIndex;
        this.availableFrameCounts[n] = this.availableFrameCounts[n] + nFrames;
        this.frameAvailability.set(senderIndex);
        this.notifyAll();
    }

    public synchronized void notifyEndOfStream(IInputChannel channel) {
        PartitionId pid = (PartitionId)channel.getAttachment();
        int senderIndex = pid.getSenderIndex();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("EOS: " + pid);
        }
        this.eosSenders.set(senderIndex);
        this.notifyAll();
    }
}

