/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.std.collectors;

import edu.uci.ics.hyracks.api.channels.IInputChannel;
import edu.uci.ics.hyracks.api.channels.IInputChannelMonitor;
import edu.uci.ics.hyracks.api.comm.IFrameReader;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.dataflow.common.comm.util.FrameUtils;
import java.nio.ByteBuffer;

public class InputChannelFrameReader
implements IFrameReader,
IInputChannelMonitor {
    private final IInputChannel channel;
    private int availableFrames;
    private boolean eos;
    private boolean failed;

    public InputChannelFrameReader(IInputChannel channel) {
        this.channel = channel;
        this.availableFrames = 0;
        this.eos = false;
        this.failed = false;
    }

    public void open() throws HyracksDataException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean nextFrame(ByteBuffer buffer) throws HyracksDataException {
        InputChannelFrameReader inputChannelFrameReader = this;
        synchronized (inputChannelFrameReader) {
            while (!this.failed && !this.eos && this.availableFrames <= 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw new HyracksDataException((Throwable)e);
                }
            }
            if (this.failed) {
                throw new HyracksDataException("Failure occurred on input");
            }
            if (this.availableFrames <= 0 && this.eos) {
                return false;
            }
            --this.availableFrames;
        }
        ByteBuffer srcBuffer = this.channel.getNextBuffer();
        FrameUtils.copy((ByteBuffer)srcBuffer, (ByteBuffer)buffer);
        this.channel.recycleBuffer(srcBuffer);
        return true;
    }

    public void close() throws HyracksDataException {
    }

    public synchronized void notifyFailure(IInputChannel channel) {
        this.failed = true;
        this.notifyAll();
    }

    public synchronized void notifyDataAvailability(IInputChannel channel, int nFrames) {
        this.availableFrames += nFrames;
        this.notifyAll();
    }

    public synchronized void notifyEndOfStream(IInputChannel channel) {
        this.eos = true;
        this.notifyAll();
    }
}

