/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.dataflow.std.base;

import edu.uci.ics.hyracks.api.application.ICCApplicationContext;
import edu.uci.ics.hyracks.api.constraints.IConstraintAcceptor;
import edu.uci.ics.hyracks.api.dataflow.IOperatorDescriptor;
import edu.uci.ics.hyracks.api.dataflow.OperatorDescriptorId;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.job.IOperatorDescriptorRegistry;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class AbstractOperatorDescriptor
implements IOperatorDescriptor {
    private static final long serialVersionUID = 1L;
    protected final OperatorDescriptorId odId;
    protected String[] partitions;
    protected final RecordDescriptor[] recordDescriptors;
    protected final int inputArity;
    protected final int outputArity;
    protected String displayName;

    public AbstractOperatorDescriptor(IOperatorDescriptorRegistry spec, int inputArity, int outputArity) {
        this.odId = spec.createOperatorDescriptorId((IOperatorDescriptor)this);
        this.inputArity = inputArity;
        this.outputArity = outputArity;
        this.recordDescriptors = new RecordDescriptor[outputArity];
        this.displayName = this.getClass().getName() + "[" + this.odId + "]";
    }

    public final OperatorDescriptorId getOperatorId() {
        return this.odId;
    }

    public int getInputArity() {
        return this.inputArity;
    }

    public int getOutputArity() {
        return this.outputArity;
    }

    public RecordDescriptor[] getOutputRecordDescriptors() {
        return this.recordDescriptors;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void contributeSchedulingConstraints(IConstraintAcceptor constraintAcceptor, ICCApplicationContext appCtx) {
    }

    public JSONObject toJSON() throws JSONException {
        JSONObject jop = new JSONObject();
        jop.put("id", (Object)String.valueOf(this.getOperatorId()));
        jop.put("java-class", (Object)this.getClass().getName());
        jop.put("in-arity", this.getInputArity());
        jop.put("out-arity", this.getOutputArity());
        jop.put("display-name", (Object)this.displayName);
        return jop;
    }
}

