/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.cc.work;

import edu.uci.ics.hyracks.api.job.JobId;
import edu.uci.ics.hyracks.control.cc.ClusterControllerService;
import edu.uci.ics.hyracks.control.cc.job.IJobStatusConditionVariable;
import edu.uci.ics.hyracks.control.common.work.IResultCallback;
import edu.uci.ics.hyracks.control.common.work.SynchronizableWork;
import java.util.List;

public class WaitForJobCompletionWork
extends SynchronizableWork {
    private final ClusterControllerService ccs;
    private final JobId jobId;
    private final IResultCallback<Object> callback;

    public WaitForJobCompletionWork(ClusterControllerService ccs, JobId jobId, IResultCallback<Object> callback) {
        this.ccs = ccs;
        this.jobId = jobId;
        this.callback = callback;
    }

    protected void doRun() throws Exception {
        final IJobStatusConditionVariable cRunningVar = this.ccs.getActiveRunMap().get(this.jobId);
        if (cRunningVar != null) {
            this.ccs.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        cRunningVar.waitForCompletion();
                        WaitForJobCompletionWork.this.callback.setValue(null);
                    }
                    catch (Exception e) {
                        WaitForJobCompletionWork.this.callback.setException(e);
                    }
                }
            });
        } else {
            final IJobStatusConditionVariable cArchivedVar = this.ccs.getRunMapArchive().get(this.jobId);
            if (cArchivedVar != null) {
                this.ccs.getExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            cArchivedVar.waitForCompletion();
                            WaitForJobCompletionWork.this.callback.setValue(null);
                        }
                        catch (Exception e) {
                            WaitForJobCompletionWork.this.callback.setException(e);
                        }
                    }
                });
            } else {
                final List<Exception> exceptions = this.ccs.getRunHistory().get(this.jobId);
                this.ccs.getExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        WaitForJobCompletionWork.this.callback.setValue(null);
                        if (exceptions != null && exceptions.size() > 0) {
                            WaitForJobCompletionWork.this.callback.setException((Exception)exceptions.get(0));
                        }
                    }
                });
            }
        }
    }
}

