/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.cc.work;

import edu.uci.ics.hyracks.api.dataflow.TaskAttemptId;
import edu.uci.ics.hyracks.api.job.ActivityCluster;
import edu.uci.ics.hyracks.api.job.JobId;
import edu.uci.ics.hyracks.control.cc.ClusterControllerService;
import edu.uci.ics.hyracks.control.cc.job.JobRun;
import edu.uci.ics.hyracks.control.cc.job.TaskAttempt;
import edu.uci.ics.hyracks.control.cc.work.AbstractTaskLifecycleWork;
import java.util.List;

public class TaskFailureWork
extends AbstractTaskLifecycleWork {
    private final List<Exception> exceptions;

    public TaskFailureWork(ClusterControllerService ccs, JobId jobId, TaskAttemptId taId, String nodeId, List<Exception> exceptions) {
        super(ccs, jobId, taId, nodeId);
        this.exceptions = exceptions;
    }

    @Override
    protected void performEvent(TaskAttempt ta) {
        JobRun run = this.ccs.getActiveRunMap().get(this.jobId);
        this.ccs.getDatasetDirectoryService().reportJobFailure(this.jobId, this.exceptions);
        ActivityCluster ac = ta.getTask().getTaskCluster().getActivityCluster();
        run.getScheduler().notifyTaskFailure(ta, ac, this.exceptions);
    }

    public String toString() {
        return "TaskFailureEvent[" + this.jobId + ":" + this.taId + ":" + this.nodeId + "]";
    }
}

