/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.cc.work;

import edu.uci.ics.hyracks.api.dataflow.TaskAttemptId;
import edu.uci.ics.hyracks.api.exceptions.HyracksException;
import edu.uci.ics.hyracks.api.job.JobId;
import edu.uci.ics.hyracks.control.cc.ClusterControllerService;
import edu.uci.ics.hyracks.control.cc.job.JobRun;
import edu.uci.ics.hyracks.control.cc.job.TaskAttempt;
import edu.uci.ics.hyracks.control.cc.work.AbstractTaskLifecycleWork;
import edu.uci.ics.hyracks.control.common.job.profiling.om.JobProfile;
import edu.uci.ics.hyracks.control.common.job.profiling.om.JobletProfile;
import edu.uci.ics.hyracks.control.common.job.profiling.om.TaskProfile;
import java.util.Map;

public class TaskCompleteWork
extends AbstractTaskLifecycleWork {
    private final TaskProfile statistics;

    public TaskCompleteWork(ClusterControllerService ccs, JobId jobId, TaskAttemptId taId, String nodeId, TaskProfile statistics) {
        super(ccs, jobId, taId, nodeId);
        this.statistics = statistics;
    }

    @Override
    protected void performEvent(TaskAttempt ta) {
        try {
            JobRun run = this.ccs.getActiveRunMap().get(this.jobId);
            if (this.statistics != null) {
                JobProfile jobProfile = run.getJobProfile();
                Map jobletProfiles = jobProfile.getJobletProfiles();
                JobletProfile jobletProfile = (JobletProfile)jobletProfiles.get(this.nodeId);
                if (jobletProfile == null) {
                    jobletProfile = new JobletProfile(this.nodeId);
                    jobletProfiles.put(this.nodeId, jobletProfile);
                }
                jobletProfile.getTaskProfiles().put(this.taId, this.statistics);
            }
            run.getScheduler().notifyTaskComplete(ta);
        }
        catch (HyracksException e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        return "TaskCompleteEvent@[" + this.nodeId + "[" + this.jobId + ":" + this.taId + "]";
    }
}

