/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.cc.work;

import edu.uci.ics.hyracks.api.job.JobId;
import edu.uci.ics.hyracks.control.cc.ClusterControllerService;
import edu.uci.ics.hyracks.control.cc.job.JobRun;
import edu.uci.ics.hyracks.control.common.job.profiling.om.JobProfile;
import edu.uci.ics.hyracks.control.common.work.AbstractWork;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class ReportProfilesWork
extends AbstractWork {
    private final ClusterControllerService ccs;
    private final List<JobProfile> profiles;

    public ReportProfilesWork(ClusterControllerService ccs, List<JobProfile> profiles) {
        this.ccs = ccs;
        this.profiles = profiles;
    }

    public void run() {
        Map<JobId, JobRun> runMap = this.ccs.getActiveRunMap();
        for (JobProfile profile : this.profiles) {
            JobRun run = runMap.get(profile.getJobId());
            if (run == null) continue;
            JobProfile jp = run.getJobProfile();
            jp.merge(profile);
        }
    }

    public Level logLevel() {
        return Level.FINEST;
    }
}

