/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.cc.work;

import edu.uci.ics.hyracks.api.job.JobId;
import edu.uci.ics.hyracks.control.cc.ClusterControllerService;
import edu.uci.ics.hyracks.control.cc.NodeControllerState;
import edu.uci.ics.hyracks.control.cc.job.JobRun;
import edu.uci.ics.hyracks.control.common.work.AbstractWork;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RemoveDeadNodesWork
extends AbstractWork {
    private static Logger LOGGER = Logger.getLogger(RemoveDeadNodesWork.class.getName());
    private final ClusterControllerService ccs;

    public RemoveDeadNodesWork(ClusterControllerService ccs) {
        this.ccs = ccs;
    }

    public void run() {
        HashSet<String> deadNodes = new HashSet<String>();
        Map<String, NodeControllerState> nodeMap = this.ccs.getNodeMap();
        for (Map.Entry<String, NodeControllerState> e : nodeMap.entrySet()) {
            NodeControllerState state = e.getValue();
            if (state.incrementLastHeartbeatDuration() < this.ccs.getConfig().maxHeartbeatLapsePeriods) continue;
            deadNodes.add(e.getKey());
            LOGGER.info(e.getKey() + " considered dead");
        }
        HashSet<JobId> affectedJobIds = new HashSet<JobId>();
        for (String deadNode : deadNodes) {
            NodeControllerState state = nodeMap.remove(deadNode);
            affectedJobIds.addAll(state.getActiveJobIds());
        }
        int size = affectedJobIds.size();
        if (size > 0) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Number of affected jobs: " + size);
            }
            for (JobId jobId : affectedJobIds) {
                JobRun run = this.ccs.getActiveRunMap().get(jobId);
                if (run == null) continue;
                run.getScheduler().notifyNodeFailures(deadNodes);
            }
        }
        if (deadNodes != null && deadNodes.size() > 0) {
            this.ccs.getApplicationContext().notifyNodeFailure(deadNodes);
        }
    }

    public Level logLevel() {
        return Level.FINE;
    }
}

