/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.cc.work;

import edu.uci.ics.hyracks.api.partitions.PartitionId;
import edu.uci.ics.hyracks.control.cc.ClusterControllerService;
import edu.uci.ics.hyracks.control.cc.job.JobRun;
import edu.uci.ics.hyracks.control.cc.partitions.PartitionMatchMaker;
import edu.uci.ics.hyracks.control.cc.partitions.PartitionUtils;
import edu.uci.ics.hyracks.control.common.job.PartitionDescriptor;
import edu.uci.ics.hyracks.control.common.job.PartitionRequest;
import edu.uci.ics.hyracks.control.common.work.AbstractWork;
import org.apache.commons.lang3.tuple.Pair;

public class RegisterPartitionRequestWork
extends AbstractWork {
    private final ClusterControllerService ccs;
    private final PartitionRequest partitionRequest;

    public RegisterPartitionRequestWork(ClusterControllerService ccs, PartitionRequest partitionRequest) {
        this.ccs = ccs;
        this.partitionRequest = partitionRequest;
    }

    public void run() {
        PartitionId pid = this.partitionRequest.getPartitionId();
        JobRun run = this.ccs.getActiveRunMap().get(pid.getJobId());
        if (run == null) {
            return;
        }
        PartitionMatchMaker pmm = run.getPartitionMatchMaker();
        Pair<PartitionDescriptor, PartitionRequest> match = pmm.matchPartitionRequest(this.partitionRequest);
        if (match != null) {
            try {
                PartitionUtils.reportPartitionMatch(this.ccs, pid, match);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String toString() {
        return "PartitionRequest@" + this.partitionRequest;
    }
}

