/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.cc.work;

import edu.uci.ics.hyracks.api.partitions.PartitionId;
import edu.uci.ics.hyracks.control.cc.ClusterControllerService;
import edu.uci.ics.hyracks.control.cc.job.JobRun;
import edu.uci.ics.hyracks.control.cc.partitions.PartitionMatchMaker;
import edu.uci.ics.hyracks.control.cc.partitions.PartitionUtils;
import edu.uci.ics.hyracks.control.common.job.PartitionDescriptor;
import edu.uci.ics.hyracks.control.common.job.PartitionRequest;
import edu.uci.ics.hyracks.control.common.work.AbstractWork;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

public class RegisterPartitionAvailibilityWork
extends AbstractWork {
    private final ClusterControllerService ccs;
    private final PartitionDescriptor partitionDescriptor;

    public RegisterPartitionAvailibilityWork(ClusterControllerService ccs, PartitionDescriptor partitionDescriptor) {
        this.ccs = ccs;
        this.partitionDescriptor = partitionDescriptor;
    }

    public void run() {
        PartitionId pid = this.partitionDescriptor.getPartitionId();
        JobRun run = this.ccs.getActiveRunMap().get(pid.getJobId());
        if (run == null) {
            return;
        }
        PartitionMatchMaker pmm = run.getPartitionMatchMaker();
        List<Pair<PartitionDescriptor, PartitionRequest>> matches = pmm.registerPartitionDescriptor(this.partitionDescriptor);
        for (Pair<PartitionDescriptor, PartitionRequest> match : matches) {
            try {
                PartitionUtils.reportPartitionMatch(this.ccs, pid, match);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String toString() {
        return "PartitionAvailable@" + this.partitionDescriptor;
    }
}

