/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.cc.work;

import edu.uci.ics.hyracks.control.cc.ClusterControllerService;
import edu.uci.ics.hyracks.control.cc.NodeControllerState;
import edu.uci.ics.hyracks.control.common.base.INodeController;
import edu.uci.ics.hyracks.control.common.controllers.NodeParameters;
import edu.uci.ics.hyracks.control.common.controllers.NodeRegistration;
import edu.uci.ics.hyracks.control.common.ipc.CCNCFunctions;
import edu.uci.ics.hyracks.control.common.ipc.NodeControllerRemoteProxy;
import edu.uci.ics.hyracks.control.common.work.SynchronizableWork;
import edu.uci.ics.hyracks.ipc.api.IIPCHandle;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RegisterNodeWork
extends SynchronizableWork {
    private static final Logger LOGGER = Logger.getLogger(RegisterNodeWork.class.getName());
    private final ClusterControllerService ccs;
    private final NodeRegistration reg;

    public RegisterNodeWork(ClusterControllerService ccs, NodeRegistration reg) {
        this.ccs = ccs;
        this.reg = reg;
    }

    protected void doRun() throws Exception {
        String id = this.reg.getNodeId();
        IIPCHandle ncIPCHandle = this.ccs.getClusterIPC().getHandle(this.reg.getNodeControllerAddress());
        CCNCFunctions.NodeRegistrationResult result = null;
        HashMap ncConfiguration = null;
        try {
            NodeControllerRemoteProxy nodeController = new NodeControllerRemoteProxy(ncIPCHandle);
            NodeControllerState state = new NodeControllerState((INodeController)nodeController, this.reg);
            Map<String, NodeControllerState> nodeMap = this.ccs.getNodeMap();
            if (nodeMap.containsKey(id)) {
                throw new Exception("Node with this name already registered.");
            }
            nodeMap.put(id, state);
            Map<String, Set<String>> ipAddressNodeNameMap = this.ccs.getIpAddressNodeNameMap();
            String ipAddress = state.getNCConfig().dataIPAddress;
            ncConfiguration = new HashMap();
            state.getNCConfig().toMap(ncConfiguration);
            Set<String> nodes = ipAddressNodeNameMap.get(ipAddress);
            if (nodes == null) {
                nodes = new HashSet<String>();
                ipAddressNodeNameMap.put(ipAddress, nodes);
            }
            nodes.add(id);
            LOGGER.log(Level.INFO, "Registered INodeController: id = " + id);
            NodeParameters params = new NodeParameters();
            params.setClusterControllerInfo(this.ccs.getClusterControllerInfo());
            params.setDistributedState(this.ccs.getApplicationContext().getDistributedState());
            params.setHeartbeatPeriod(this.ccs.getCCConfig().heartbeatPeriod);
            params.setProfileDumpPeriod(this.ccs.getCCConfig().profileDumpPeriod);
            result = new CCNCFunctions.NodeRegistrationResult(params, null);
        }
        catch (Exception e) {
            result = new CCNCFunctions.NodeRegistrationResult(null, e);
        }
        ncIPCHandle.send(-1L, (Object)result, null);
        this.ccs.getApplicationContext().notifyNodeJoin(id, ncConfiguration);
    }
}

