/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.cc.work;

import edu.uci.ics.hyracks.api.exceptions.HyracksException;
import edu.uci.ics.hyracks.api.job.ActivityClusterGraph;
import edu.uci.ics.hyracks.api.job.JobId;
import edu.uci.ics.hyracks.control.cc.ClusterControllerService;
import edu.uci.ics.hyracks.control.cc.NodeControllerState;
import edu.uci.ics.hyracks.control.cc.application.CCApplicationContext;
import edu.uci.ics.hyracks.control.cc.job.JobRun;
import edu.uci.ics.hyracks.control.cc.work.AbstractHeartbeatWork;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class JobletCleanupNotificationWork
extends AbstractHeartbeatWork {
    private static final Logger LOGGER = Logger.getLogger(JobletCleanupNotificationWork.class.getName());
    private ClusterControllerService ccs;
    private JobId jobId;
    private String nodeId;

    public JobletCleanupNotificationWork(ClusterControllerService ccs, JobId jobId, String nodeId) {
        super(ccs, nodeId, null);
        this.ccs = ccs;
        this.jobId = jobId;
        this.nodeId = nodeId;
    }

    @Override
    public void runWork() {
        JobRun run = this.ccs.getActiveRunMap().get(this.jobId);
        Set<String> cleanupPendingNodes = run.getCleanupPendingNodeIds();
        if (!cleanupPendingNodes.remove(this.nodeId)) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning(this.nodeId + " not in pending cleanup nodes set: " + cleanupPendingNodes + " for Job: " + this.jobId);
            }
            return;
        }
        NodeControllerState ncs = this.ccs.getNodeMap().get(this.nodeId);
        if (ncs != null) {
            ncs.getActiveJobIds().remove(this.jobId);
        }
        if (cleanupPendingNodes.isEmpty()) {
            CCApplicationContext appCtx = this.ccs.getApplicationContext();
            if (appCtx != null) {
                try {
                    appCtx.notifyJobFinish(this.jobId);
                }
                catch (HyracksException e) {
                    e.printStackTrace();
                }
            }
            run.setStatus(run.getPendingStatus(), run.getPendingExceptions());
            this.ccs.getActiveRunMap().remove(this.jobId);
            this.ccs.getRunMapArchive().put(this.jobId, run);
            this.ccs.getRunHistory().put(this.jobId, run.getExceptions());
            try {
                this.ccs.getJobLogFile().log(this.createJobLogObject(run));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private JSONObject createJobLogObject(JobRun run) {
        JSONObject jobLogObject = new JSONObject();
        try {
            ActivityClusterGraph acg = run.getActivityClusterGraph();
            jobLogObject.put("activity-cluster-graph", (Object)acg.toJSON());
            jobLogObject.put("job-run", (Object)run.toJSON());
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return jobLogObject;
    }
}

