/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.cc.work;

import edu.uci.ics.hyracks.api.application.IApplicationContext;
import edu.uci.ics.hyracks.api.application.ICCApplicationContext;
import edu.uci.ics.hyracks.api.deployment.DeploymentId;
import edu.uci.ics.hyracks.api.job.IActivityClusterGraphGenerator;
import edu.uci.ics.hyracks.api.job.IActivityClusterGraphGeneratorFactory;
import edu.uci.ics.hyracks.api.job.JobFlag;
import edu.uci.ics.hyracks.api.job.JobId;
import edu.uci.ics.hyracks.api.job.JobStatus;
import edu.uci.ics.hyracks.control.cc.ClusterControllerService;
import edu.uci.ics.hyracks.control.cc.application.CCApplicationContext;
import edu.uci.ics.hyracks.control.cc.job.JobRun;
import edu.uci.ics.hyracks.control.cc.work.JobCleanupWork;
import edu.uci.ics.hyracks.control.common.deployment.DeploymentUtils;
import edu.uci.ics.hyracks.control.common.work.AbstractWork;
import edu.uci.ics.hyracks.control.common.work.IResultCallback;
import edu.uci.ics.hyracks.control.common.work.SynchronizableWork;
import java.util.Collections;
import java.util.EnumSet;

public class JobStartWork
extends SynchronizableWork {
    private final ClusterControllerService ccs;
    private final byte[] acggfBytes;
    private final EnumSet<JobFlag> jobFlags;
    private final DeploymentId deploymentId;
    private final JobId jobId;
    private final IResultCallback<JobId> callback;

    public JobStartWork(ClusterControllerService ccs, DeploymentId deploymentId, byte[] acggfBytes, EnumSet<JobFlag> jobFlags, JobId jobId, IResultCallback<JobId> callback) {
        this.deploymentId = deploymentId;
        this.jobId = jobId;
        this.ccs = ccs;
        this.acggfBytes = acggfBytes;
        this.jobFlags = jobFlags;
        this.callback = callback;
    }

    protected void doRun() throws Exception {
        try {
            CCApplicationContext appCtx = this.ccs.getApplicationContext();
            IActivityClusterGraphGeneratorFactory acggf = (IActivityClusterGraphGeneratorFactory)DeploymentUtils.deserialize((byte[])this.acggfBytes, (DeploymentId)this.deploymentId, (IApplicationContext)appCtx);
            IActivityClusterGraphGenerator acgg = acggf.createActivityClusterGraphGenerator(this.jobId, (ICCApplicationContext)appCtx, this.jobFlags);
            JobRun run = new JobRun(this.ccs, this.deploymentId, this.jobId, acgg, this.jobFlags);
            run.setStatus(JobStatus.INITIALIZED, null);
            this.ccs.getActiveRunMap().put(this.jobId, run);
            appCtx.notifyJobCreation(this.jobId, acggf);
            run.setStatus(JobStatus.RUNNING, null);
            try {
                run.getScheduler().startJob();
            }
            catch (Exception e) {
                this.ccs.getWorkQueue().schedule((AbstractWork)new JobCleanupWork(this.ccs, run.getJobId(), JobStatus.FAILURE, Collections.singletonList(e)));
            }
            this.callback.setValue((Object)this.jobId);
        }
        catch (Exception e) {
            this.callback.setException(e);
        }
    }
}

