/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.cc.work;

import edu.uci.ics.hyracks.api.exceptions.HyracksException;
import edu.uci.ics.hyracks.api.job.ActivityClusterGraph;
import edu.uci.ics.hyracks.api.job.JobId;
import edu.uci.ics.hyracks.api.job.JobStatus;
import edu.uci.ics.hyracks.control.cc.ClusterControllerService;
import edu.uci.ics.hyracks.control.cc.NodeControllerState;
import edu.uci.ics.hyracks.control.cc.application.CCApplicationContext;
import edu.uci.ics.hyracks.control.cc.job.JobRun;
import edu.uci.ics.hyracks.control.common.work.AbstractWork;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class JobCleanupWork
extends AbstractWork {
    private static final Logger LOGGER = Logger.getLogger(JobCleanupWork.class.getName());
    private ClusterControllerService ccs;
    private JobId jobId;
    private JobStatus status;
    private List<Exception> exceptions;

    public JobCleanupWork(ClusterControllerService ccs, JobId jobId, JobStatus status, List<Exception> exceptions) {
        this.ccs = ccs;
        this.jobId = jobId;
        this.status = status;
        this.exceptions = exceptions;
    }

    public void run() {
        LOGGER.info("Cleanup for JobRun with id: " + this.jobId);
        JobRun run = this.ccs.getActiveRunMap().get(this.jobId);
        if (run == null) {
            LOGGER.warning("Unable to find JobRun with id: " + this.jobId);
            return;
        }
        if (run.getPendingStatus() != null && run.getCleanupPendingNodeIds().isEmpty()) {
            this.finishJob(run);
            return;
        }
        if (run.getPendingStatus() != null) {
            LOGGER.warning("Ignoring duplicate cleanup for JobRun with id: " + this.jobId);
            return;
        }
        Set<String> targetNodes = run.getParticipatingNodeIds();
        run.getCleanupPendingNodeIds().addAll(targetNodes);
        if (run.getPendingStatus() != JobStatus.FAILURE && run.getPendingStatus() != JobStatus.TERMINATED) {
            run.setPendingStatus(this.status, this.exceptions);
        }
        if (targetNodes != null && !targetNodes.isEmpty()) {
            HashSet<String> toDelete = new HashSet<String>();
            for (String n : targetNodes) {
                NodeControllerState ncs = this.ccs.getNodeMap().get(n);
                try {
                    if (ncs == null) {
                        toDelete.add(n);
                        continue;
                    }
                    ncs.getNodeController().cleanUpJoblet(this.jobId, this.status);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            targetNodes.removeAll(toDelete);
            run.getCleanupPendingNodeIds().removeAll(toDelete);
            if (run.getCleanupPendingNodeIds().isEmpty()) {
                this.finishJob(run);
            }
        } else {
            this.finishJob(run);
        }
    }

    private void finishJob(JobRun run) {
        CCApplicationContext appCtx = this.ccs.getApplicationContext();
        if (appCtx != null) {
            try {
                appCtx.notifyJobFinish(this.jobId);
            }
            catch (HyracksException e) {
                e.printStackTrace();
            }
        }
        run.setStatus(run.getPendingStatus(), run.getPendingExceptions());
        this.ccs.getActiveRunMap().remove(this.jobId);
        this.ccs.getRunMapArchive().put(this.jobId, run);
        this.ccs.getRunHistory().put(this.jobId, run.getExceptions());
        try {
            this.ccs.getJobLogFile().log(this.createJobLogObject(run));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private JSONObject createJobLogObject(JobRun run) {
        JSONObject jobLogObject = new JSONObject();
        try {
            ActivityClusterGraph acg = run.getActivityClusterGraph();
            jobLogObject.put("activity-cluster-graph", (Object)acg.toJSON());
            jobLogObject.put("job-run", (Object)run.toJSON());
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return jobLogObject;
    }
}

