/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.control.cc.work;

import edu.uci.ics.hyracks.api.dataset.DatasetJobRecord;
import edu.uci.ics.hyracks.api.dataset.ResultSetId;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.api.job.JobId;
import edu.uci.ics.hyracks.control.cc.ClusterControllerService;
import edu.uci.ics.hyracks.control.common.work.IResultCallback;
import edu.uci.ics.hyracks.control.common.work.SynchronizableWork;

public class GetResultStatusWork
extends SynchronizableWork {
    private final ClusterControllerService ccs;
    private final JobId jobId;
    private final ResultSetId rsId;
    private final IResultCallback<DatasetJobRecord.Status> callback;

    public GetResultStatusWork(ClusterControllerService ccs, JobId jobId, ResultSetId rsId, IResultCallback<DatasetJobRecord.Status> callback) {
        this.ccs = ccs;
        this.jobId = jobId;
        this.rsId = rsId;
        this.callback = callback;
    }

    public void doRun() {
        try {
            DatasetJobRecord.Status status = this.ccs.getDatasetDirectoryService().getResultStatus(this.jobId, this.rsId);
            this.callback.setValue((Object)status);
        }
        catch (HyracksDataException e) {
            this.callback.setException((Exception)((Object)e));
        }
    }

    public String toString() {
        return "JobId@" + this.jobId + " ResultSetId@" + this.rsId;
    }
}

